/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Strings;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortListener;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.impl.OpenstackSwitchingHandler;
import org.onosproject.openstacknetworking.impl.RulePopulatorUtil;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.openstack4j.model.network.Network;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class OpenstackSwitchingHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_SET_FLOWS = "Failed to set flows for %s: ";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler"));
    private final InstancePortListener instancePortListener = new InternalInstancePortListener(this, null);
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.instancePortService.addListener((EventListener)this.instancePortListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.instancePortService.removeListener((EventListener)this.instancePortListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void setNetworkRules(InstancePort instPort, boolean install) {
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[this.osNetworkService.network(instPort.networkId()).getNetworkType().ordinal()]) {
            case 1: {
                this.setTunnelTagFlowRules(instPort, install);
                this.setForwardingRules(instPort, install);
                break;
            }
            case 2: {
                this.setVlanTagFlowRules(instPort, install);
                this.setForwardingRulesForVlan(instPort, install);
                break;
            }
        }
    }

    private void setForwardingRules(InstancePort instPort, boolean install) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(instPort.ipAddress().toIpPrefix()).matchTunnelId(this.getVni(instPort).longValue()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setEthDst(instPort.macAddress()).setOutput(instPort.portNumber()).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)instPort.deviceId(), (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
        this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).filter(osNode -> !osNode.intBridge().equals((Object)instPort.deviceId())).forEach(osNode -> {
            TrafficTreatment treatmentToRemote = DefaultTrafficTreatment.builder().extension(RulePopulatorUtil.buildExtension((DeviceService)this.deviceService, (DeviceId)osNode.intBridge(), (Ip4Address)((IpAddress)this.osNodeService.dataIp(instPort.deviceId()).get()).getIp4Address()), osNode.intBridge()).setOutput((PortNumber)this.osNodeService.tunnelPort(osNode.intBridge()).get()).build();
            RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)osNode.intBridge(), (TrafficSelector)selector, (TrafficTreatment)treatmentToRemote, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
        });
    }

    private void setForwardingRulesForVlan(InstancePort instPort, boolean install) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(instPort.ipAddress().toIpPrefix()).matchVlanId(this.getVlanId(instPort)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().popVlan().setEthDst(instPort.macAddress()).setOutput(instPort.portNumber()).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)instPort.deviceId(), (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
        this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).filter(osNode -> !osNode.intBridge().equals((Object)instPort.deviceId())).filter(osNode -> osNode.vlanPort().isPresent()).forEach(osNode -> {
            TrafficTreatment treatmentToRemote = DefaultTrafficTreatment.builder().setOutput((PortNumber)this.osNodeService.vlanPort(osNode.intBridge()).get()).build();
            RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)osNode.intBridge(), (TrafficSelector)selector, (TrafficTreatment)treatmentToRemote, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
        });
    }

    private void setTunnelTagFlowRules(InstancePort instPort, boolean install) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchInPort(instPort.portNumber()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(this.getVni(instPort).longValue()).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)instPort.deviceId(), (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
    }

    private void setVlanTagFlowRules(InstancePort instPort, boolean install) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchInPort(instPort.portNumber()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().pushVlan().setVlanId(this.getVlanId(instPort)).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)instPort.deviceId(), (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
    }

    private VlanId getVlanId(InstancePort instPort) {
        Network osNet = this.osNetworkService.network(instPort.networkId());
        if (osNet == null || Strings.isNullOrEmpty((String)osNet.getProviderSegID())) {
            String error = String.format("Failed to set flows for %s: Failed to get VNI for %s", instPort, osNet == null ? "<none>" : osNet.getName());
            throw new IllegalStateException(error);
        }
        return VlanId.vlanId((String)osNet.getProviderSegID());
    }

    private Long getVni(InstancePort instPort) {
        Network osNet = this.osNetworkService.network(instPort.networkId());
        if (osNet == null || Strings.isNullOrEmpty((String)osNet.getProviderSegID())) {
            String error = String.format("Failed to set flows for %s: Failed to get VNI for %s", instPort, osNet == null ? "<none>" : osNet.getName());
            throw new IllegalStateException(error);
        }
        return Long.valueOf(osNet.getProviderSegID());
    }

    static /* synthetic */ ExecutorService access$100(OpenstackSwitchingHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$200(OpenstackSwitchingHandler x0, InstancePort x1, boolean x2) {
        x0.setNetworkRules(x1, x2);
    }

    static /* synthetic */ Logger access$300(OpenstackSwitchingHandler x0) {
        return x0.log;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }
}

