/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Strings;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.TpPort;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.impl.OpenstackSwitchingDhcpHandler;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackSwitchingDhcpHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DHCP_SERVER_MAC = "dhcpServerMac";
    private static final Ip4Address DEFAULT_DNS = Ip4Address.valueOf((String)"8.8.8.8");
    private static final byte PACKET_TTL = 127;
    private static final byte DHCP_OPTION_MTU = 26;
    private static final byte[] DHCP_DATA_LEASE_INFINITE = ByteBuffer.allocate(4).putInt(-1).array();
    private static final byte[] DHCP_DATA_MTU_DEFAULT = ByteBuffer.allocate(2).putShort((short)1450).array();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Property(name="dhcpServerMac", value={"fe:00:00:00:00:02"}, label="Fake MAC address for virtual network subnet gateway")
    private String dhcpServerMac = "fe:00:00:00:00:02";
    private final PacketProcessor packetProcessor = new InternalPacketProcessor(this, null);
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.configService.registerProperties(this.getClass());
        this.packetService.addProcessor(this.packetProcessor, PacketProcessor.director((int)0));
        this.requestPackets();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.cancelPackets();
        this.packetService.removeProcessor(this.packetProcessor);
        this.configService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String updatedMac = Tools.get((Dictionary)properties, (String)DHCP_SERVER_MAC);
        if (!Strings.isNullOrEmpty((String)updatedMac) && !updatedMac.equals(this.dhcpServerMac)) {
            this.dhcpServerMac = updatedMac;
        }
        this.log.info("Modified");
    }

    private void requestPackets() {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)67)).matchUdpSrc(TpPort.tpPort((int)68)).build();
        this.packetService.requestPackets(selector, PacketPriority.CONTROL, this.appId);
    }

    private void cancelPackets() {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)67)).matchUdpSrc(TpPort.tpPort((int)68)).build();
        this.packetService.cancelPackets(selector, PacketPriority.CONTROL, this.appId);
    }

    static /* synthetic */ String access$100(OpenstackSwitchingDhcpHandler x0) {
        return x0.dhcpServerMac;
    }

    static /* synthetic */ byte[] access$200() {
        return DHCP_DATA_LEASE_INFINITE;
    }

    static /* synthetic */ Ip4Address access$300() {
        return DEFAULT_DNS;
    }

    static /* synthetic */ byte[] access$400() {
        return DHCP_DATA_MTU_DEFAULT;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }
}

