/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.impl.OpenstackSwitchingArpHandler;
import org.openstack4j.model.network.Subnet;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class OpenstackSwitchingArpHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String GATEWAY_MAC = "gatewayMac";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Property(name="gatewayMac", value={"fe:00:00:00:00:02"}, label="Fake MAC address for virtual network subnet gateway")
    private String gatewayMac = "fe:00:00:00:00:02";
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor(this, null);
    private final InternalOpenstackNetworkListener osNetworkListener = new InternalOpenstackNetworkListener(this, null);
    private final Set<IpAddress> gateways = Sets.newConcurrentHashSet();
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.configService.registerProperties(this.getClass());
        this.osNetworkService.addListener((EventListener)this.osNetworkListener);
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)0));
        this.osNetworkService.subnets().forEach(arg_0 -> this.addSubnetGateway(arg_0));
        this.requestPacket();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.osNetworkService.removeListener((EventListener)this.osNetworkListener);
        this.configService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String updatedMac = Tools.get((Dictionary)properties, (String)GATEWAY_MAC);
        if (!Strings.isNullOrEmpty((String)updatedMac) && !updatedMac.equals(this.gatewayMac)) {
            this.gatewayMac = updatedMac;
        }
        this.log.info("Modified");
    }

    private void requestPacket() {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.ARP.ethType().toShort()).build();
        this.packetService.requestPackets(selector, PacketPriority.CONTROL, this.appId);
    }

    private void addSubnetGateway(Subnet osSubnet) {
        if (Strings.isNullOrEmpty((String)osSubnet.getGateway())) {
            return;
        }
        IpAddress gatewayIp = IpAddress.valueOf((String)osSubnet.getGateway());
        this.gateways.add(gatewayIp);
        this.log.debug("Added ARP proxy entry IP:{}", (Object)gatewayIp);
    }

    private void removeSubnetGateway(Subnet osSubnet) {
        if (Strings.isNullOrEmpty((String)osSubnet.getGateway())) {
            return;
        }
        IpAddress gatewayIp = IpAddress.valueOf((String)osSubnet.getGateway());
        this.gateways.remove(gatewayIp);
        this.log.debug("Removed ARP proxy entry IP:{}", (Object)gatewayIp);
    }

    private void processPacketIn(PacketContext context, Ethernet ethPacket) {
        MacAddress replyMac;
        ARP arpPacket = (ARP)ethPacket.getPayload();
        if (arpPacket.getOpCode() != 1) {
            return;
        }
        InstancePort srcInstPort = this.instancePortService.instancePort(ethPacket.getSourceMAC());
        if (srcInstPort == null) {
            this.log.trace("Failed to find source instance port(MAC:{})", (Object)ethPacket.getSourceMAC());
            return;
        }
        Ip4Address targetIp = Ip4Address.valueOf((byte[])arpPacket.getTargetProtocolAddress());
        MacAddress macAddress = replyMac = this.gateways.contains(targetIp) ? MacAddress.valueOf((String)this.gatewayMac) : this.getMacFromHostOpenstack((IpAddress)targetIp, srcInstPort.networkId());
        if (replyMac == MacAddress.NONE) {
            this.log.trace("Failed to find MAC address for {}", (Object)targetIp);
            return;
        }
        Ethernet ethReply = ARP.buildArpReply((Ip4Address)targetIp.getIp4Address(), (MacAddress)replyMac, (Ethernet)ethPacket);
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(context.inPacket().receivedFrom().port()).build();
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(context.inPacket().receivedFrom().deviceId(), treatment, ByteBuffer.wrap(ethReply.serialize())));
    }

    private MacAddress getMacFromHostOpenstack(IpAddress targetIp, String osNetId) {
        Preconditions.checkNotNull((Object)targetIp);
        InstancePort instPort = this.instancePortService.instancePort(targetIp, osNetId);
        if (instPort != null) {
            this.log.trace("Found MAC from host service for {}", (Object)targetIp);
            return instPort.macAddress();
        }
        return MacAddress.NONE;
    }

    static /* synthetic */ void access$200(OpenstackSwitchingArpHandler x0, PacketContext x1, Ethernet x2) {
        x0.processPacketIn(x1, x2);
    }

    static /* synthetic */ void access$300(OpenstackSwitchingArpHandler x0, Subnet x1) {
        x0.addSubnetGateway(x1);
    }

    static /* synthetic */ void access$400(OpenstackSwitchingArpHandler x0, Subnet x1) {
        x0.removeSubnetGateway(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }
}

