/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.CoreService;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupAdminService;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupEvent;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupListener;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupService;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupStore;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupStoreDelegate;
import org.onosproject.openstacknetworking.impl.OpenstackSecurityGroupManager;
import org.onosproject.store.StoreDelegate;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.model.network.builder.NetSecurityGroupBuilder;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class OpenstackSecurityGroupManager
extends ListenerRegistry<OpenstackSecurityGroupEvent, OpenstackSecurityGroupListener>
implements OpenstackSecurityGroupAdminService,
OpenstackSecurityGroupService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_SG = "OpenStack security group %s %s";
    private static final String MSG_SG_RULE = "OpenStack security group rule %s %s";
    private static final String MSG_CREATED = "created";
    private static final String MSG_REMOVED = "removed";
    private static final String ERR_NULL_SG = "OpenStack security group cannot be null";
    private static final String ERR_NULL_SG_ID = "OpenStack security group ID cannot be null";
    private static final String ERR_NULL_SG_RULE = "OpenStack security group rule cannot be null";
    private static final String ERR_NULL_SG_RULE_ID = "OpenStack security group rule ID cannot be null";
    private static final String ERR_NOT_FOUND = "not found";
    private static final String ERR_DUPLICATE = "already exist";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackSecurityGroupStore osSecurityGroupStore;
    private final OpenstackSecurityGroupStoreDelegate delegate = new InternalSecurityGroupStoreDelegate(this, null);

    @Activate
    protected void activate() {
        this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osSecurityGroupStore.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osSecurityGroupStore.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
    }

    public void createSecurityGroup(SecurityGroup sg) {
        Preconditions.checkNotNull((Object)sg, (Object)ERR_NULL_SG);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sg.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_SG_ID);
        this.osSecurityGroupStore.createSecurityGroup(sg);
        this.log.info(String.format(MSG_SG, sg.getId(), MSG_CREATED));
    }

    public void updateSecurityGroup(SecurityGroup sg) {
        Preconditions.checkNotNull((Object)sg, (Object)ERR_NULL_SG);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sg.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_SG_ID);
        this.osSecurityGroupStore.updateSecurityGroup(sg);
    }

    public void removeSecurityGroup(String sgId) {
        Preconditions.checkNotNull((Object)sgId, (Object)ERR_NULL_SG_ID);
        this.osSecurityGroupStore.removeSecurityGroup(sgId);
        this.log.info(String.format(MSG_SG, sgId, MSG_REMOVED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSecurityGroupRule(SecurityGroupRule sgRule) {
        Preconditions.checkNotNull((Object)sgRule, (Object)ERR_NULL_SG_RULE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sgRule.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_SG_RULE_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sgRule.getSecurityGroupId()) ? 1 : 0) != 0, (Object)ERR_NULL_SG_ID);
        OpenstackSecurityGroupManager openstackSecurityGroupManager = this;
        synchronized (openstackSecurityGroupManager) {
            SecurityGroup sg = this.securityGroup(sgRule.getSecurityGroupId());
            if (sg == null) {
                String error = String.format(MSG_SG, sgRule.getSecurityGroupId(), ERR_NOT_FOUND);
                throw new IllegalStateException(error);
            }
            if (sg.getRules().stream().anyMatch(rule -> Objects.equals(rule.getId(), sgRule.getId()))) {
                String error = String.format(MSG_SG_RULE, sgRule.getSecurityGroupId(), ERR_DUPLICATE);
                throw new IllegalStateException(error);
            }
            List updatedSgRules = sg.getRules();
            updatedSgRules.add(sgRule);
            SecurityGroup updatedSg = (SecurityGroup)((NetSecurityGroupBuilder)NeutronSecurityGroup.builder().from((Buildable)sg)).build();
            this.osSecurityGroupStore.updateSecurityGroup(updatedSg);
        }
        this.log.info(String.format(MSG_SG_RULE, sgRule.getId(), MSG_CREATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityGroupRule(String sgRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sgRuleId) ? 1 : 0) != 0, (Object)ERR_NULL_SG_RULE_ID);
        OpenstackSecurityGroupManager openstackSecurityGroupManager = this;
        synchronized (openstackSecurityGroupManager) {
            SecurityGroupRule sgRule = this.securityGroupRule(sgRuleId);
            if (sgRule == null) {
                String error = String.format(MSG_SG_RULE, sgRuleId, ERR_NOT_FOUND);
                throw new IllegalStateException(error);
            }
            SecurityGroup sg = this.securityGroup(sgRule.getSecurityGroupId());
            if (sg == null) {
                String error = String.format(MSG_SG, sgRule.getSecurityGroupId(), ERR_NOT_FOUND);
                throw new IllegalStateException(error);
            }
            if (sg.getRules().stream().noneMatch(rule -> Objects.equals(rule.getId(), sgRule.getId()))) {
                String error = String.format(MSG_SG_RULE, sgRule.getSecurityGroupId(), ERR_NOT_FOUND);
                throw new IllegalStateException(error);
            }
            List updatedSgRules = sg.getRules();
            updatedSgRules.removeIf(r -> ((SecurityGroupRule)r).getId().equals(sgRuleId));
            SecurityGroup updatedSg = (SecurityGroup)((NetSecurityGroupBuilder)NeutronSecurityGroup.builder().from((Buildable)sg)).build();
            this.osSecurityGroupStore.updateSecurityGroup(updatedSg);
        }
        this.log.info(String.format(MSG_SG_RULE, sgRuleId, MSG_REMOVED));
    }

    public Set<SecurityGroup> securityGroups() {
        return this.osSecurityGroupStore.securityGroups();
    }

    public SecurityGroup securityGroup(String sgId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sgId) ? 1 : 0) != 0, (Object)ERR_NULL_SG_ID);
        return this.osSecurityGroupStore.securityGroup(sgId);
    }

    public void clear() {
        this.osSecurityGroupStore.clear();
    }

    private SecurityGroupRule securityGroupRule(String sgRuleId) {
        return this.osSecurityGroupStore.securityGroups().stream().flatMap(sg -> sg.getRules().stream()).filter(sgRule -> Objects.equals(sgRule.getId(), sgRuleId)).findFirst().orElse(null);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindOsSecurityGroupStore(OpenstackSecurityGroupStore openstackSecurityGroupStore) {
        this.osSecurityGroupStore = openstackSecurityGroupStore;
    }

    protected void unbindOsSecurityGroupStore(OpenstackSecurityGroupStore openstackSecurityGroupStore) {
        if (this.osSecurityGroupStore == openstackSecurityGroupStore) {
            this.osSecurityGroupStore = null;
        }
    }
}

