/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TpPort;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortListener;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkListener;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupListener;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupService;
import org.onosproject.openstacknetworking.impl.OpenstackSecurityGroupHandler;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackSecurityGroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackSecurityGroupService securityGroupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    private final InstancePortListener instancePortListener = new InternalInstancePortListener(this, null);
    private final OpenstackNetworkListener portListener = new InternalOpenstackPortListener(this, null);
    private final OpenstackSecurityGroupListener securityGroupListener = new InternalSecurityGroupListener(this, null);
    private ApplicationId appId;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler"));
    private static final String PROTO_ICMP = "ICMP";
    private static final String PROTO_TCP = "TCP";
    private static final String PROTO_UDP = "UDP";
    private static final String ETHTYPE_IPV4 = "IPV4";
    private static final String EGRESS = "EGRESS";
    private static final String INGRESS = "INGRESS";
    private static final IpPrefix IP_PREFIX_ANY = Ip4Prefix.valueOf((String)"0.0.0.0/0");

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.instancePortService.addListener((EventListener)this.instancePortListener);
        this.securityGroupService.addListener((EventListener)this.securityGroupListener);
        this.osNetService.addListener((EventListener)this.portListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.instancePortService.removeListener((EventListener)this.instancePortListener);
        this.securityGroupService.removeListener((EventListener)this.securityGroupListener);
        this.osNetService.removeListener((EventListener)this.portListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void setSecurityGroupRules(InstancePort instPort, Port port, boolean install) {
        port.getSecurityGroups().forEach(sgId -> {
            SecurityGroup sg = this.securityGroupService.securityGroup(sgId);
            if (sg == null) {
                this.log.error("Security Group Not Found : {}", sgId);
                return;
            }
            sg.getRules().forEach(sgRule -> this.updateSecurityGroupRule(instPort, port, sgRule, install));
            String action = install ? "Installed " : "Removed ";
            this.log.debug(action + "security group rule ID : " + sgId);
        });
    }

    private void updateSecurityGroupRule(InstancePort instPort, Port port, SecurityGroupRule sgRule, boolean install) {
        if (sgRule.getRemoteGroupId() != null && !sgRule.getRemoteGroupId().isEmpty()) {
            this.getRemoteInstPorts(port.getTenantId(), sgRule.getRemoteGroupId()).forEach(rInstPort -> {
                this.populateSecurityGroupRule(sgRule, instPort, rInstPort.ipAddress().toIpPrefix(), install);
                this.populateSecurityGroupRule(sgRule, rInstPort, instPort.ipAddress().toIpPrefix(), install);
                SecurityGroupRule rSgRule = (SecurityGroupRule)new NeutronSecurityGroupRule.SecurityGroupRuleConcreteBuilder().from(sgRule).direction(sgRule.getDirection().toUpperCase().equals(EGRESS) ? INGRESS : EGRESS).build();
                this.populateSecurityGroupRule(rSgRule, instPort, rInstPort.ipAddress().toIpPrefix(), install);
                this.populateSecurityGroupRule(rSgRule, rInstPort, instPort.ipAddress().toIpPrefix(), install);
            });
        } else {
            this.populateSecurityGroupRule(sgRule, instPort, sgRule.getRemoteIpPrefix() == null ? IP_PREFIX_ANY : IpPrefix.valueOf((String)sgRule.getRemoteIpPrefix()), install);
        }
    }

    private void populateSecurityGroupRule(SecurityGroupRule sgRule, InstancePort instPort, IpPrefix remoteIp, boolean install) {
        ForwardingObjective.Builder foBuilder = this.buildFlowObjective(sgRule, Ip4Address.valueOf((InetAddress)instPort.ipAddress().toInetAddress()), remoteIp);
        if (foBuilder == null) {
            return;
        }
        if (install) {
            this.flowObjectiveService.forward(instPort.deviceId(), foBuilder.add());
        } else {
            this.flowObjectiveService.forward(instPort.deviceId(), foBuilder.remove());
        }
    }

    private Set<InstancePort> getRemoteInstPorts(String tenantId, String sgId) {
        Set remoteInstPorts = this.osNetService.ports().stream().filter(port -> port.getTenantId().equals(tenantId)).filter(port -> port.getSecurityGroups().contains(sgId)).map(port -> this.instancePortService.instancePort(port.getId())).filter(instPort -> instPort != null && instPort.ipAddress() != null).collect(Collectors.toSet());
        return Collections.unmodifiableSet(remoteInstPorts);
    }

    private ForwardingObjective.Builder buildFlowObjective(SecurityGroupRule sgRule, Ip4Address vmIp, IpPrefix remoteIp) {
        if (remoteIp != null && remoteIp.equals((Object)IpPrefix.valueOf((IpAddress)vmIp, (int)32))) {
            return null;
        }
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        this.buildMatchs(sBuilder, sgRule, vmIp, remoteIp);
        return DefaultForwardingObjective.builder().withSelector(sBuilder.build()).withTreatment(DefaultTrafficTreatment.builder().build()).withPriority(30000).withFlag(ForwardingObjective.Flag.SPECIFIC).fromApp(this.appId);
    }

    private void buildMatchs(TrafficSelector.Builder sBuilder, SecurityGroupRule sgRule, Ip4Address vmIp, IpPrefix remoteIp) {
        this.buildMatchEthType(sBuilder, sgRule.getEtherType());
        this.buildMatchDirection(sBuilder, sgRule.getDirection(), vmIp);
        this.buildMatchProto(sBuilder, sgRule.getProtocol());
        this.buildMatchPort(sBuilder, sgRule.getProtocol(), sgRule.getDirection(), sgRule.getPortRangeMax() == null ? 0 : sgRule.getPortRangeMax(), sgRule.getPortRangeMin() == null ? 0 : sgRule.getPortRangeMin());
        this.buildMatchRemoteIp(sBuilder, remoteIp, sgRule.getDirection());
        if (sgRule.getRemoteGroupId() != null && sgRule.getRemoteGroupId().isEmpty()) {
            this.buildMatchRemoteIp(sBuilder, remoteIp, sgRule.getDirection());
        }
    }

    private void buildMatchDirection(TrafficSelector.Builder sBuilder, String direction, Ip4Address vmIp) {
        if (direction.toUpperCase().equals(EGRESS)) {
            sBuilder.matchIPSrc(IpPrefix.valueOf((IpAddress)vmIp, (int)32));
        } else {
            sBuilder.matchIPDst(IpPrefix.valueOf((IpAddress)vmIp, (int)32));
        }
    }

    private void buildMatchEthType(TrafficSelector.Builder sBuilder, String etherType) {
        sBuilder.matchEthType(Ethernet.TYPE_IPV4);
        if (etherType != null && !Objects.equals(etherType, "null") && !etherType.toUpperCase().equals(ETHTYPE_IPV4)) {
            this.log.debug("EthType {} is not supported yet in Security Group", (Object)etherType);
        }
    }

    private void buildMatchRemoteIp(TrafficSelector.Builder sBuilder, IpPrefix remoteIpPrefix, String direction) {
        if (remoteIpPrefix != null && !remoteIpPrefix.getIp4Prefix().equals((Object)IP_PREFIX_ANY)) {
            if (direction.toUpperCase().equals(EGRESS)) {
                sBuilder.matchIPDst(remoteIpPrefix);
            } else {
                sBuilder.matchIPSrc(remoteIpPrefix);
            }
        }
    }

    private void buildMatchProto(TrafficSelector.Builder sBuilder, String protocol) {
        if (protocol != null) {
            switch (protocol.toUpperCase()) {
                case "ICMP": {
                    sBuilder.matchIPProtocol((byte)1);
                    break;
                }
                case "TCP": {
                    sBuilder.matchIPProtocol((byte)6);
                    break;
                }
                case "UDP": {
                    sBuilder.matchIPProtocol((byte)17);
                    break;
                }
            }
        }
    }

    private void buildMatchPort(TrafficSelector.Builder sBuilder, String protocol, String direction, int portMin, int portMax) {
        if (portMin > 0 && portMax > 0 && portMin == portMax) {
            if (protocol.toUpperCase().equals(PROTO_TCP)) {
                if (direction.toUpperCase().equals(EGRESS)) {
                    sBuilder.matchTcpSrc(TpPort.tpPort((int)portMax));
                } else {
                    sBuilder.matchTcpDst(TpPort.tpPort((int)portMax));
                }
            } else if (protocol.toUpperCase().equals(PROTO_UDP)) {
                if (direction.toUpperCase().equals(EGRESS)) {
                    sBuilder.matchUdpSrc(TpPort.tpPort((int)portMax));
                } else {
                    sBuilder.matchUdpDst(TpPort.tpPort((int)portMax));
                }
            }
        }
    }

    static /* synthetic */ Logger access$300(OpenstackSecurityGroupHandler x0) {
        return x0.log;
    }

    static /* synthetic */ ExecutorService access$400(OpenstackSecurityGroupHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$500(OpenstackSecurityGroupHandler x0, InstancePort x1, Port x2, boolean x3) {
        x0.setSecurityGroupRules(x1, x2, x3);
    }

    static /* synthetic */ void access$600(OpenstackSecurityGroupHandler x0, InstancePort x1, Port x2, SecurityGroupRule x3, boolean x4) {
        x0.updateSecurityGroupRule(x1, x2, x3, x4);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindOsNetService(OpenstackNetworkService openstackNetworkService) {
        this.osNetService = openstackNetworkService;
    }

    protected void unbindOsNetService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetService == openstackNetworkService) {
            this.osNetService = null;
        }
    }

    protected void bindSecurityGroupService(OpenstackSecurityGroupService openstackSecurityGroupService) {
        this.securityGroupService = openstackSecurityGroupService;
    }

    protected void unbindSecurityGroupService(OpenstackSecurityGroupService openstackSecurityGroupService) {
        if (this.securityGroupService == openstackSecurityGroupService) {
            this.securityGroupService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }
}

