/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TCP;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.openstacknetworking.api.Constants;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.impl.OpenstackRoutingSnatHandler;
import org.onosproject.openstacknetworking.impl.RulePopulatorUtil;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.openstack4j.model.network.ExternalGateway;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackRoutingSnatHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_PACKETIN = "Failed to handle packet in: ";
    private static final String ERR_UNSUPPORTED_NET_TYPE = "Unsupported network type";
    private static final int TIME_OUT_SNAT_RULE = 120;
    private static final long TIME_OUT_SNAT_PORT_MS = 120000L;
    private static final int TP_PORT_MINIMUM_NUM = 65000;
    private static final int TP_PORT_MAXIMUM_NUM = 65535;
    private static final KryoNamespace.Builder NUMBER_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackRouterService osRouterService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor(this, null);
    private ConsistentMap<Integer, Long> allocatedPortNumMap;
    private DistributedSet<Integer> unUsedPortNumSet;
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.allocatedPortNumMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)NUMBER_SERIALIZER.build()))).withName("openstackrouting-allocatedportnummap")).withApplicationId(this.appId)).build();
        this.unUsedPortNumSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("openstackrouting-unusedportnumset")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.initializeUnusedPortNumSet();
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)1));
        this.log.info("Started");
    }

    private void initializeUnusedPortNumSet() {
        for (int i = 65000; i < 65535; ++i) {
            if (this.allocatedPortNumMap.containsKey((Object)i)) continue;
            this.unUsedPortNumSet.add((Object)i);
        }
        this.clearPortNumMap();
    }

    @Deactivate
    protected void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void processSnatPacket(PacketContext context, Ethernet eth) {
        IPv4 iPacket = (IPv4)eth.getPayload();
        InboundPacket packetIn = context.inPacket();
        int patPort = this.getPortNum();
        InstancePort srcInstPort = this.instancePortService.instancePort(eth.getSourceMAC());
        if (srcInstPort == null) {
            this.log.error("Failed to handle packet in: source host(MAC:{}) does not exist", (Object)eth.getSourceMAC());
            return;
        }
        IpAddress srcIp = IpAddress.valueOf((int)iPacket.getSourceAddress());
        Subnet srcSubnet = this.getSourceSubnet(srcInstPort, srcIp);
        IpAddress externalGatewayIp = this.getExternalIp(srcSubnet);
        if (externalGatewayIp == null) {
            return;
        }
        this.populateSnatFlowRules(context.inPacket(), srcInstPort, TpPort.tpPort((int)patPort), externalGatewayIp);
        this.packetOut((Ethernet)eth.clone(), packetIn.receivedFrom().deviceId(), patPort, externalGatewayIp);
    }

    private Subnet getSourceSubnet(InstancePort instance, IpAddress srcIp) {
        Port osPort = this.osNetworkService.port(instance.portId());
        IP fixedIp = osPort.getFixedIps().stream().filter(ip -> IpAddress.valueOf((String)ip.getIpAddress()).equals((Object)srcIp)).findAny().orElse(null);
        if (fixedIp == null) {
            return null;
        }
        return this.osNetworkService.subnet(fixedIp.getSubnetId());
    }

    private IpAddress getExternalIp(Subnet srcSubnet) {
        RouterInterface osRouterIface = this.osRouterService.routerInterfaces().stream().filter(i -> Objects.equals(i.getSubnetId(), srcSubnet.getId())).findAny().orElse(null);
        if (osRouterIface == null) {
            this.log.trace("Failed to handle packet in: source subnet(ID:{}, CIDR:{}) has no router", (Object)srcSubnet.getId(), (Object)srcSubnet.getCidr());
            return null;
        }
        Router osRouter = this.osRouterService.router(osRouterIface.getId());
        if (osRouter.getExternalGatewayInfo() == null) {
            this.log.trace("Failed to handle packet in: router({}) has no external gateway", (Object)osRouter.getName());
            return null;
        }
        ExternalGateway exGatewayInfo = osRouter.getExternalGatewayInfo();
        if (!exGatewayInfo.isEnableSnat()) {
            this.log.trace("Failed to handle packet in: router({}) SNAT is disabled", (Object)osRouter.getName());
            return null;
        }
        Port exGatewayPort = this.osNetworkService.ports(exGatewayInfo.getNetworkId()).stream().filter(port -> Objects.equals(port.getDeviceId(), osRouter.getId())).findAny().orElse(null);
        if (exGatewayPort == null) {
            this.log.trace("Failed to handle packet in: no external gateway port for router({})", (Object)osRouter.getName());
            return null;
        }
        return IpAddress.valueOf((String)((IP)exGatewayPort.getFixedIps().stream().findFirst().get()).getIpAddress());
    }

    private void populateSnatFlowRules(InboundPacket packetIn, InstancePort srcInstPort, TpPort patPort, IpAddress externalIp) {
        Network osNet = this.osNetworkService.network(srcInstPort.networkId());
        if (osNet == null) {
            String error = String.format("Failed to handle packet in: network %s not found", srcInstPort.networkId());
            throw new IllegalStateException(error);
        }
        this.setDownstreamRules(srcInstPort, osNet.getProviderSegID(), osNet.getNetworkType(), externalIp, patPort, packetIn);
        this.setUpstreamRules(osNet.getProviderSegID(), osNet.getNetworkType(), externalIp, patPort, packetIn);
    }

    private void setDownstreamRules(InstancePort srcInstPort, String segmentId, NetworkType networkType, IpAddress externalIp, TpPort patPort, InboundPacket packetIn) {
        IPv4 iPacket = (IPv4)packetIn.parsed().getPayload();
        IpAddress internalIp = IpAddress.valueOf((int)iPacket.getSourceAddress());
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol(iPacket.getProtocol()).matchIPDst(IpPrefix.valueOf((IpAddress)externalIp, (int)32)).matchIPSrc(IpPrefix.valueOf((int)iPacket.getDestinationAddress(), (int)32));
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder().setEthDst(packetIn.parsed().getSourceMAC()).setIpDst(internalIp);
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
            case 1: {
                tBuilder.setTunnelId(Long.parseLong(segmentId));
                break;
            }
            case 2: {
                tBuilder.pushVlan().setVlanId(VlanId.vlanId((String)segmentId)).setEthSrc(Constants.DEFAULT_GATEWAY_MAC);
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", networkType.toString());
                throw new IllegalStateException(error);
            }
        }
        switch (iPacket.getProtocol()) {
            case 6: {
                TCP tcpPacket = (TCP)iPacket.getPayload();
                sBuilder.matchTcpSrc(TpPort.tpPort((int)tcpPacket.getDestinationPort())).matchTcpDst(patPort);
                tBuilder.setTcpDst(TpPort.tpPort((int)tcpPacket.getSourcePort()));
                break;
            }
            case 17: {
                UDP udpPacket = (UDP)iPacket.getPayload();
                sBuilder.matchUdpSrc(TpPort.tpPort((int)udpPacket.getDestinationPort())).matchUdpDst(patPort);
                tBuilder.setUdpDst(TpPort.tpPort((int)udpPacket.getSourcePort()));
                break;
            }
        }
        this.osNodeService.gatewayDeviceIds().forEach(deviceId -> {
            DeviceId srcDeviceId = srcInstPort.deviceId();
            TrafficTreatment.Builder tmpBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)tBuilder.build());
            switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
                case 1: {
                    tmpBuilder.extension(RulePopulatorUtil.buildExtension((DeviceService)this.deviceService, (DeviceId)deviceId, (Ip4Address)((IpAddress)this.osNodeService.dataIp(srcDeviceId).get()).getIp4Address()), deviceId).setOutput((PortNumber)this.osNodeService.tunnelPort(deviceId).get());
                    break;
                }
                case 2: {
                    tmpBuilder.setOutput((PortNumber)this.osNodeService.vlanPort(deviceId).get());
                    break;
                }
                default: {
                    String error = String.format("Unsupported network type%s", networkType.toString());
                    throw new IllegalStateException(error);
                }
            }
            ForwardingObjective fo = DefaultForwardingObjective.builder().withSelector(sBuilder.build()).withTreatment(tmpBuilder.build()).withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(26000).makeTemporary(120).fromApp(this.appId).add();
            this.flowObjectiveService.forward(deviceId, fo);
        });
    }

    private void setUpstreamRules(String segmentId, NetworkType networkType, IpAddress externalIp, TpPort patPort, InboundPacket packetIn) {
        IPv4 iPacket = (IPv4)packetIn.parsed().getPayload();
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol(iPacket.getProtocol()).matchIPSrc(IpPrefix.valueOf((int)iPacket.getSourceAddress(), (int)32)).matchIPDst(IpPrefix.valueOf((int)iPacket.getDestinationAddress(), (int)32));
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
            case 1: {
                sBuilder.matchTunnelId(Long.parseLong(segmentId));
                break;
            }
            case 2: {
                sBuilder.matchVlanId(VlanId.vlanId((String)segmentId));
                tBuilder.popVlan();
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", networkType.toString());
                throw new IllegalStateException(error);
            }
        }
        switch (iPacket.getProtocol()) {
            case 6: {
                TCP tcpPacket = (TCP)iPacket.getPayload();
                sBuilder.matchTcpSrc(TpPort.tpPort((int)tcpPacket.getSourcePort())).matchTcpDst(TpPort.tpPort((int)tcpPacket.getDestinationPort()));
                tBuilder.setTcpSrc(patPort).setEthDst(Constants.DEFAULT_EXTERNAL_ROUTER_MAC);
                break;
            }
            case 17: {
                UDP udpPacket = (UDP)iPacket.getPayload();
                sBuilder.matchUdpSrc(TpPort.tpPort((int)udpPacket.getSourcePort())).matchUdpDst(TpPort.tpPort((int)udpPacket.getDestinationPort()));
                tBuilder.setUdpSrc(patPort).setEthDst(Constants.DEFAULT_EXTERNAL_ROUTER_MAC);
                break;
            }
            default: {
                this.log.debug("Unsupported IPv4 protocol {}");
            }
        }
        tBuilder.setIpSrc(externalIp);
        this.osNodeService.gatewayDeviceIds().forEach(deviceId -> {
            TrafficTreatment.Builder tmpBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)tBuilder.build());
            tmpBuilder.setOutput((PortNumber)this.osNodeService.externalPort(deviceId).get());
            ForwardingObjective fo = DefaultForwardingObjective.builder().withSelector(sBuilder.build()).withTreatment(tmpBuilder.build()).withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(26000).makeTemporary(120).fromApp(this.appId).add();
            this.flowObjectiveService.forward(deviceId, fo);
        });
    }

    private void packetOut(Ethernet ethPacketIn, DeviceId srcDevice, int patPort, IpAddress externalIp) {
        IPv4 iPacket = (IPv4)ethPacketIn.getPayload();
        switch (iPacket.getProtocol()) {
            case 6: {
                TCP tcpPacket = (TCP)iPacket.getPayload();
                tcpPacket.setSourcePort(patPort);
                tcpPacket.resetChecksum();
                tcpPacket.setParent((IPacket)iPacket);
                iPacket.setPayload((IPacket)tcpPacket);
                break;
            }
            case 17: {
                UDP udpPacket = (UDP)iPacket.getPayload();
                udpPacket.setSourcePort(patPort);
                udpPacket.resetChecksum();
                udpPacket.setParent((IPacket)iPacket);
                iPacket.setPayload((IPacket)udpPacket);
                break;
            }
            default: {
                this.log.trace("Temporally, this method can process UDP and TCP protocol.");
                return;
            }
        }
        iPacket.setSourceAddress(externalIp.toString());
        iPacket.resetChecksum();
        iPacket.setParent((IPacket)ethPacketIn);
        ethPacketIn.setDestinationMACAddress(Constants.DEFAULT_EXTERNAL_ROUTER_MAC);
        ethPacketIn.setPayload((IPacket)iPacket);
        ethPacketIn.resetChecksum();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput((PortNumber)this.osNodeService.externalPort(srcDevice).get()).build();
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(srcDevice, treatment, ByteBuffer.wrap(ethPacketIn.serialize())));
    }

    private int getPortNum() {
        int portNum;
        if (this.unUsedPortNumSet.isEmpty()) {
            this.clearPortNumMap();
        }
        if ((portNum = this.findUnusedPortNum()) != 0) {
            this.unUsedPortNumSet.remove((Object)portNum);
            this.allocatedPortNumMap.put((Object)portNum, (Object)System.currentTimeMillis());
        }
        return portNum;
    }

    private int findUnusedPortNum() {
        return this.unUsedPortNumSet.stream().findAny().orElse(0);
    }

    private void clearPortNumMap() {
        this.allocatedPortNumMap.entrySet().forEach(e -> {
            if (System.currentTimeMillis() - (Long)((Versioned)e.getValue()).value() > 120000L) {
                this.allocatedPortNumMap.remove(e.getKey());
                this.unUsedPortNumSet.add(e.getKey());
            }
        });
    }

    static /* synthetic */ ExecutorService access$100(OpenstackRoutingSnatHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$200(OpenstackRoutingSnatHandler x0, PacketContext x1, Ethernet x2) {
        x0.processSnatPacket(x1, x2);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsRouterService(OpenstackRouterService openstackRouterService) {
        this.osRouterService = openstackRouterService;
    }

    protected void unbindOsRouterService(OpenstackRouterService openstackRouterService) {
        if (this.osRouterService == openstackRouterService) {
            this.osRouterService = null;
        }
    }
}

