/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.openstacknetworking.api.Constants;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.impl.OpenstackRoutingIcmpHandler;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.openstack4j.model.network.ExternalGateway;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackRoutingIcmpHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_REQ = "Failed to handle ICMP request: ";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackRouterService osRouterService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor(this, null);
    private final InternalNodeListener nodeListener = new InternalNodeListener(this, null);
    private final Map<String, InstancePort> icmpInfoMap = Maps.newHashMap();
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)1));
        this.osNodeService.addListener((EventListener)this.nodeListener);
        this.requestPacket(this.appId);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.osNodeService.removeListener((EventListener)this.nodeListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void requestPacket(ApplicationId appId) {
        TrafficSelector icmpSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)1).build();
        this.osNodeService.gatewayDeviceIds().forEach(gateway -> {
            this.packetService.requestPackets(icmpSelector, PacketPriority.CONTROL, appId, Optional.of(gateway));
            this.log.debug("Requested ICMP packet to {}", gateway);
        });
    }

    private void processIcmpPacket(PacketContext context, Ethernet ethernet) {
        IPv4 ipPacket = (IPv4)ethernet.getPayload();
        ICMP icmp = (ICMP)ipPacket.getPayload();
        this.log.trace("Processing ICMP packet source MAC:{}, source IP:{},dest MAC:{}, dest IP:{}", new Object[]{ethernet.getSourceMAC(), IpAddress.valueOf((int)ipPacket.getSourceAddress()), ethernet.getDestinationMAC(), IpAddress.valueOf((int)ipPacket.getDestinationAddress())});
        switch (icmp.getIcmpType()) {
            case 8: {
                this.handleEchoRequest(context.inPacket().receivedFrom().deviceId(), ethernet.getSourceMAC(), ipPacket, icmp);
                context.block();
                break;
            }
            case 0: {
                this.handleEchoReply(ipPacket, icmp);
                context.block();
                break;
            }
        }
    }

    private void handleEchoRequest(DeviceId srcDevice, MacAddress srcMac, IPv4 ipPacket, ICMP icmp) {
        InstancePort instPort = this.instancePortService.instancePort(srcMac);
        if (instPort == null) {
            this.log.trace("Failed to handle ICMP request: unknown source host(MAC:{})", (Object)srcMac);
            return;
        }
        IpAddress srcIp = IpAddress.valueOf((int)ipPacket.getSourceAddress());
        Subnet srcSubnet = this.getSourceSubnet(instPort, srcIp);
        if (srcSubnet == null) {
            this.log.trace("Failed to handle ICMP request: unknown source subnet(IP:{})", (Object)srcIp);
            return;
        }
        if (Strings.isNullOrEmpty((String)srcSubnet.getGateway())) {
            this.log.trace("Failed to handle ICMP request: source subnet(ID:{}, CIDR:{}) has no gateway", (Object)srcSubnet.getId(), (Object)srcSubnet.getCidr());
            return;
        }
        if (this.isForSubnetGateway(IpAddress.valueOf((int)ipPacket.getDestinationAddress()), srcSubnet)) {
            this.processRequestForGateway(ipPacket, instPort);
        } else {
            IpAddress externalIp = this.getExternalIp(srcSubnet);
            if (externalIp == null) {
                return;
            }
            this.log.debug("1");
            this.sendRequestForExternal(ipPacket, srcDevice, externalIp);
            this.log.debug("2");
            String icmpInfoKey = String.valueOf(this.getIcmpId(icmp)).concat(String.valueOf(externalIp.getIp4Address().toInt())).concat(String.valueOf(ipPacket.getDestinationAddress()));
            this.icmpInfoMap.putIfAbsent(icmpInfoKey, instPort);
        }
    }

    private void handleEchoReply(IPv4 ipPacket, ICMP icmp) {
        String icmpInfoKey = String.valueOf(this.getIcmpId(icmp)).concat(String.valueOf(ipPacket.getDestinationAddress())).concat(String.valueOf(ipPacket.getSourceAddress()));
        this.processReplyFromExternal(ipPacket, (InstancePort)this.icmpInfoMap.get(icmpInfoKey));
        this.icmpInfoMap.remove(icmpInfoKey);
    }

    private Subnet getSourceSubnet(InstancePort instance, IpAddress srcIp) {
        Port osPort = this.osNetworkService.port(instance.portId());
        IP fixedIp = osPort.getFixedIps().stream().filter(ip -> IpAddress.valueOf((String)ip.getIpAddress()).equals((Object)srcIp)).findAny().orElse(null);
        if (fixedIp == null) {
            return null;
        }
        return this.osNetworkService.subnet(fixedIp.getSubnetId());
    }

    private boolean isForSubnetGateway(IpAddress dstIp, Subnet srcSubnet) {
        RouterInterface osRouterIface = this.osRouterService.routerInterfaces().stream().filter(i -> Objects.equals(i.getSubnetId(), srcSubnet.getId())).findAny().orElse(null);
        if (osRouterIface == null) {
            this.log.trace("Failed to handle ICMP request: source subnet(ID:{}, CIDR:{}) has no router", (Object)srcSubnet.getId(), (Object)srcSubnet.getCidr());
            return false;
        }
        Router osRouter = this.osRouterService.router(osRouterIface.getId());
        Set routableGateways = this.osRouterService.routerInterfaces(osRouter.getId()).stream().map(iface -> this.osNetworkService.subnet(iface.getSubnetId()).getGateway()).map(IpAddress::valueOf).collect(Collectors.toSet());
        return routableGateways.contains(dstIp);
    }

    private IpAddress getExternalIp(Subnet srcSubnet) {
        RouterInterface osRouterIface = this.osRouterService.routerInterfaces().stream().filter(i -> Objects.equals(i.getSubnetId(), srcSubnet.getId())).findAny().orElse(null);
        if (osRouterIface == null) {
            String error = String.format("Failed to handle ICMP request: subnet(ID:%s, CIDR:%s) is not connected to any router", srcSubnet.getId(), srcSubnet.getCidr());
            throw new IllegalStateException(error);
        }
        Router osRouter = this.osRouterService.router(osRouterIface.getId());
        if (osRouter.getExternalGatewayInfo() == null) {
            String error = String.format("Failed to handle ICMP request: router(ID:%s, name:%s) does not have external gateway", osRouter.getId(), osRouter.getName());
            throw new IllegalStateException(error);
        }
        ExternalGateway exGatewayInfo = osRouter.getExternalGatewayInfo();
        Port exGatewayPort = this.osNetworkService.ports(exGatewayInfo.getNetworkId()).stream().filter(port -> Objects.equals(port.getDeviceId(), osRouter.getId())).findAny().orElse(null);
        if (exGatewayPort == null) {
            String error = String.format("Failed to handle ICMP request: no external gateway port for router (ID:%s, name:%s)", osRouter.getId(), osRouter.getName());
            throw new IllegalStateException(error);
        }
        return IpAddress.valueOf((String)((IP)exGatewayPort.getFixedIps().stream().findFirst().get()).getIpAddress());
    }

    private void processRequestForGateway(IPv4 ipPacket, InstancePort instPort) {
        ICMP icmpReq = (ICMP)ipPacket.getPayload();
        icmpReq.setChecksum((short)0);
        icmpReq.setIcmpType((byte)0).resetChecksum();
        int destinationAddress = ipPacket.getSourceAddress();
        ipPacket.setSourceAddress(ipPacket.getDestinationAddress()).setDestinationAddress(destinationAddress).resetChecksum();
        ipPacket.setPayload((IPacket)icmpReq);
        Ethernet icmpReply = new Ethernet();
        icmpReply.setEtherType(Ethernet.TYPE_IPV4).setSourceMACAddress(Constants.DEFAULT_GATEWAY_MAC).setDestinationMACAddress(instPort.macAddress()).setPayload((IPacket)ipPacket);
        this.sendReply(icmpReply, instPort);
    }

    private void sendRequestForExternal(IPv4 ipPacket, DeviceId srcDevice, IpAddress srcNatIp) {
        ICMP icmpReq = (ICMP)ipPacket.getPayload();
        icmpReq.resetChecksum();
        ipPacket.setSourceAddress(srcNatIp.getIp4Address().toInt()).resetChecksum();
        ipPacket.setPayload((IPacket)icmpReq);
        Ethernet icmpRequestEth = new Ethernet();
        icmpRequestEth.setEtherType(Ethernet.TYPE_IPV4).setSourceMACAddress(Constants.DEFAULT_GATEWAY_MAC).setDestinationMACAddress(Constants.DEFAULT_EXTERNAL_ROUTER_MAC).setPayload((IPacket)ipPacket);
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput((PortNumber)this.osNodeService.externalPort(srcDevice).get()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(srcDevice, treatment, ByteBuffer.wrap(icmpRequestEth.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    private void processReplyFromExternal(IPv4 ipPacket, InstancePort instPort) {
        ICMP icmpReply = (ICMP)ipPacket.getPayload();
        icmpReply.resetChecksum();
        ipPacket.setDestinationAddress(instPort.ipAddress().getIp4Address().toInt()).resetChecksum();
        ipPacket.setPayload((IPacket)icmpReply);
        Ethernet icmpResponseEth = new Ethernet();
        icmpResponseEth.setEtherType(Ethernet.TYPE_IPV4).setSourceMACAddress(Constants.DEFAULT_GATEWAY_MAC).setDestinationMACAddress(instPort.macAddress()).setPayload((IPacket)ipPacket);
        this.sendReply(icmpResponseEth, instPort);
    }

    private void sendReply(Ethernet icmpReply, InstancePort instPort) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(instPort.portNumber()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(instPort.deviceId(), treatment, ByteBuffer.wrap(icmpReply.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    private short getIcmpId(ICMP icmp) {
        return ByteBuffer.wrap(icmp.serialize(), 4, 2).getShort();
    }

    static /* synthetic */ ExecutorService access$200(OpenstackRoutingIcmpHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$300(OpenstackRoutingIcmpHandler x0, PacketContext x1, Ethernet x2) {
        x0.processIcmpPacket(x1, x2);
    }

    static /* synthetic */ ApplicationId access$400(OpenstackRoutingIcmpHandler x0) {
        return x0.appId;
    }

    static /* synthetic */ void access$500(OpenstackRoutingIcmpHandler x0, ApplicationId x1) {
        x0.requestPacket(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsRouterService(OpenstackRouterService openstackRouterService) {
        this.osRouterService = openstackRouterService;
    }

    protected void unbindOsRouterService(OpenstackRouterService openstackRouterService) {
        if (this.osRouterService == openstackRouterService) {
            this.osRouterService = null;
        }
    }
}

