/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.openstacknetworking.api.Constants;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterListener;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.impl.OpenstackRoutingHandler;
import org.onosproject.openstacknetworking.impl.RulePopulatorUtil;
import org.onosproject.openstacknode.OpenstackNodeListener;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.openstack4j.model.network.ExternalGateway;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackRoutingHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_ENABLED = "Enabled ";
    private static final String MSG_DISABLED = "Disabled ";
    private static final String ERR_SET_FLOWS = "Failed to set flows for router %s:";
    private static final String ERR_UNSUPPORTED_NET_TYPE = "Unsupported network type";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackRouterService osRouterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final OpenstackNodeListener osNodeListener = new InternalNodeEventListener(this, null);
    private final OpenstackRouterListener osRouterListener = new InternalRouterEventListener(this, null);
    private ApplicationId appId;
    private NodeId localNodeId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.runForLeadership(this.appId.name());
        this.osNodeService.addListener((EventListener)this.osNodeListener);
        this.osRouterService.addListener((EventListener)this.osRouterListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osRouterService.removeListener((EventListener)this.osRouterListener);
        this.osNodeService.removeListener((EventListener)this.osNodeListener);
        this.leadershipService.withdraw(this.appId.name());
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void routerUpdated(Router osRouter) {
        ExternalGateway exGateway = osRouter.getExternalGatewayInfo();
        if (exGateway == null) {
            this.osRouterService.routerInterfaces(osRouter.getId()).forEach(iface -> this.setSourceNat(iface, false));
        } else {
            this.osRouterService.routerInterfaces(osRouter.getId()).forEach(iface -> this.setSourceNat(iface, exGateway.isEnableSnat()));
        }
    }

    private void routerIfaceAdded(Router osRouter, RouterInterface osRouterIface) {
        Subnet osSubnet = this.osNetworkService.subnet(osRouterIface.getSubnetId());
        if (osSubnet == null) {
            String error = String.format("Failed to set flows for router %s:subnet %s does not exist", osRouterIface.getId(), osRouterIface.getSubnetId());
            throw new IllegalStateException(error);
        }
        this.setInternalRoutes(osRouter, osSubnet, true);
        this.setGatewayIcmp(osSubnet, true);
        ExternalGateway exGateway = osRouter.getExternalGatewayInfo();
        if (exGateway != null && exGateway.isEnableSnat()) {
            this.setSourceNat(osRouterIface, true);
        }
        this.log.info("Connected subnet({}) to {}", (Object)osSubnet.getCidr(), (Object)osRouter.getName());
    }

    private void routerIfaceRemoved(Router osRouter, RouterInterface osRouterIface) {
        Subnet osSubnet = this.osNetworkService.subnet(osRouterIface.getSubnetId());
        if (osSubnet == null) {
            String error = String.format("Failed to set flows for router %s:subnet %s does not exist", osRouterIface.getId(), osRouterIface.getSubnetId());
            throw new IllegalStateException(error);
        }
        this.setInternalRoutes(osRouter, osSubnet, false);
        this.setGatewayIcmp(osSubnet, false);
        ExternalGateway exGateway = osRouter.getExternalGatewayInfo();
        if (exGateway != null && exGateway.isEnableSnat()) {
            this.setSourceNat(osRouterIface, false);
        }
        this.log.info("Disconnected subnet({}) from {}", (Object)osSubnet.getCidr(), (Object)osRouter.getName());
    }

    private void setSourceNat(RouterInterface routerIface, boolean install) {
        Subnet osSubnet = this.osNetworkService.subnet(routerIface.getSubnetId());
        Network osNet = this.osNetworkService.network(osSubnet.getNetworkId());
        this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).forEach(osNode -> this.setRulesToGateway(osNode.intBridge(), osNet.getProviderSegID(), IpPrefix.valueOf((String)osSubnet.getCidr()), osNet.getNetworkType(), install));
        this.osNodeService.gatewayDeviceIds().forEach(gwDeviceId -> this.setRulesToController(gwDeviceId, osNet.getProviderSegID(), IpPrefix.valueOf((String)osSubnet.getCidr()), osNet.getNetworkType(), install));
        String updateStr = install ? MSG_ENABLED : MSG_DISABLED;
        this.log.info(updateStr + "external access for subnet({})", (Object)osSubnet.getCidr());
    }

    private void setGatewayIcmp(Subnet osSubnet, boolean install) {
        if (Strings.isNullOrEmpty((String)osSubnet.getGateway())) {
            return;
        }
        Network network = this.osNetworkService.network(osSubnet.getNetworkId());
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[network.getNetworkType().ordinal()]) {
            case 1: {
                this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).filter(osNode -> osNode.dataIp().isPresent()).forEach(osNode -> this.setRulesToGatewayWithDstIp(osNode.intBridge(), this.osNodeService.gatewayGroupId(osNode.intBridge(), OpenstackNodeService.NetworkMode.VXLAN), network.getProviderSegID(), IpAddress.valueOf((String)osSubnet.getGateway()), OpenstackNodeService.NetworkMode.VXLAN, install));
                break;
            }
            case 2: {
                this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).filter(osNode -> osNode.vlanPort().isPresent()).forEach(osNode -> this.setRulesToGatewayWithDstIp(osNode.intBridge(), this.osNodeService.gatewayGroupId(osNode.intBridge(), OpenstackNodeService.NetworkMode.VLAN), network.getProviderSegID(), IpAddress.valueOf((String)osSubnet.getGateway()), OpenstackNodeService.NetworkMode.VLAN, install));
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", network.getNetworkType().toString());
                throw new IllegalStateException(error);
            }
        }
        IpAddress gatewayIp = IpAddress.valueOf((String)osSubnet.getGateway());
        this.osNodeService.gatewayDeviceIds().forEach(gwDeviceId -> this.setGatewayIcmpRule(gatewayIp, gwDeviceId, install));
        String updateStr = install ? MSG_ENABLED : MSG_DISABLED;
        this.log.debug(updateStr + "ICMP to {}", (Object)osSubnet.getGateway());
    }

    private void setInternalRoutes(Router osRouter, Subnet updatedSubnet, boolean install) {
        Network updatedNetwork = this.osNetworkService.network(updatedSubnet.getNetworkId());
        Set routableSubnets = this.routableSubnets(osRouter, updatedSubnet.getId());
        String updatedSegmendId = this.getSegmentId(updatedSubnet);
        this.osNodeService.completeNodes().stream().filter(osNode -> osNode.type() == OpenstackNodeService.NodeType.COMPUTE).forEach(osNode -> {
            this.setInternalRouterRules(osNode.intBridge(), updatedSegmendId, updatedSegmendId, IpPrefix.valueOf((String)updatedSubnet.getCidr()), IpPrefix.valueOf((String)updatedSubnet.getCidr()), updatedNetwork.getNetworkType(), install);
            routableSubnets.forEach(subnet -> {
                this.setInternalRouterRules(osNode.intBridge(), updatedSegmendId, this.getSegmentId(subnet), IpPrefix.valueOf((String)updatedSubnet.getCidr()), IpPrefix.valueOf((String)subnet.getCidr()), updatedNetwork.getNetworkType(), install);
                this.setInternalRouterRules(osNode.intBridge(), this.getSegmentId(subnet), updatedSegmendId, IpPrefix.valueOf((String)subnet.getCidr()), IpPrefix.valueOf((String)updatedSubnet.getCidr()), updatedNetwork.getNetworkType(), install);
            });
        });
        String updateStr = install ? MSG_ENABLED : MSG_DISABLED;
        routableSubnets.forEach(subnet -> this.log.debug(updateStr + "route between subnet:{} and subnet:{}", (Object)subnet.getCidr(), (Object)updatedSubnet.getCidr()));
    }

    private Set<Subnet> routableSubnets(Router osRouter, String osSubnetId) {
        Set osSubnets = this.osRouterService.routerInterfaces(osRouter.getId()).stream().filter(iface -> !Objects.equals(iface.getSubnetId(), osSubnetId)).map(iface -> this.osNetworkService.subnet(iface.getSubnetId())).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osSubnets);
    }

    private String getSegmentId(Subnet osSubnet) {
        return this.osNetworkService.network(osSubnet.getNetworkId()).getProviderSegID();
    }

    private void setGatewayIcmpRule(IpAddress gatewayIp, DeviceId deviceId, boolean install) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)1).matchIPDst(gatewayIp.toIpPrefix()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.CONTROLLER).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.VERSATILE, (int)43000, (boolean)install);
    }

    private void setInternalRouterRules(DeviceId deviceId, String srcSegmentId, String dstSegmentId, IpPrefix srcSubnet, IpPrefix dstSubnet, NetworkType networkType, boolean install) {
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
            case 1: {
                TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.parseLong(srcSegmentId)).matchIPSrc(srcSubnet).matchIPDst(dstSubnet).build();
                TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(dstSegmentId)).build();
                RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)28000, (boolean)install);
                selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.parseLong(dstSegmentId)).matchIPSrc(srcSubnet).matchIPDst(dstSubnet).build();
                treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(dstSegmentId)).build();
                RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)28000, (boolean)install);
                break;
            }
            case 2: {
                TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchVlanId(VlanId.vlanId((String)srcSegmentId)).matchIPSrc(srcSubnet).matchIPDst(dstSubnet).build();
                TrafficTreatment treatment = DefaultTrafficTreatment.builder().setVlanId(VlanId.vlanId((String)dstSegmentId)).build();
                RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)28000, (boolean)install);
                selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchVlanId(VlanId.vlanId((String)dstSegmentId)).matchIPSrc(srcSubnet).matchIPDst(dstSubnet).build();
                treatment = DefaultTrafficTreatment.builder().setVlanId(VlanId.vlanId((String)dstSegmentId)).build();
                RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)28000, (boolean)install);
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", networkType.toString());
                throw new IllegalStateException(error);
            }
        }
    }

    private void setRulesToGateway(DeviceId deviceId, String segmentId, IpPrefix srcSubnet, NetworkType networkType, boolean install) {
        GroupId groupId;
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(srcSubnet).matchEthDst(Constants.DEFAULT_GATEWAY_MAC);
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
            case 1: {
                sBuilder.matchTunnelId(Long.parseLong(segmentId));
                groupId = this.osNodeService.gatewayGroupId(deviceId, OpenstackNodeService.NetworkMode.VXLAN);
                break;
            }
            case 2: {
                sBuilder.matchVlanId(VlanId.vlanId((String)segmentId));
                groupId = this.osNodeService.gatewayGroupId(deviceId, OpenstackNodeService.NetworkMode.VLAN);
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", networkType.toString());
                throw new IllegalStateException(error);
            }
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().group(groupId).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)sBuilder.build(), (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)25000, (boolean)install);
    }

    private void setRulesToController(DeviceId deviceId, String segmentId, IpPrefix srcSubnet, NetworkType networkType, boolean install) {
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(srcSubnet);
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[networkType.ordinal()]) {
            case 1: {
                sBuilder.matchTunnelId(Long.parseLong(segmentId)).matchEthDst(Constants.DEFAULT_GATEWAY_MAC);
                break;
            }
            case 2: {
                sBuilder.matchVlanId(VlanId.vlanId((String)segmentId)).matchEthDst(MacAddress.valueOf((String)this.vlanPortMac(deviceId)));
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", networkType.toString());
                throw new IllegalStateException(error);
            }
        }
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder().setEthDst(Constants.DEFAULT_GATEWAY_MAC);
        if (networkType.equals((Object)NetworkType.VLAN)) {
            tBuilder.popVlan();
        }
        tBuilder.setOutput(PortNumber.CONTROLLER);
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)sBuilder.build(), (TrafficTreatment)tBuilder.build(), (ForwardingObjective.Flag)ForwardingObjective.Flag.VERSATILE, (int)25000, (boolean)install);
    }

    private String vlanPortMac(DeviceId deviceId) {
        return this.deviceService.getPorts(deviceId).stream().filter(p -> p.annotations().value("portName").equals(this.osNodeService.gatewayNode(deviceId).vlanPort().get()) && p.isEnabled()).findFirst().get().annotations().value("portMac");
    }

    private void setRulesToGatewayWithDstIp(DeviceId deviceId, GroupId groupId, String segmentId, IpAddress dstIp, OpenstackNodeService.NetworkMode networkMode, boolean install) {
        TrafficSelector selector = networkMode.equals((Object)OpenstackNodeService.NetworkMode.VXLAN) ? DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.valueOf(segmentId).longValue()).matchIPDst(dstIp.toIpPrefix()).build() : DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchVlanId(VlanId.vlanId((String)segmentId)).matchIPDst(dstIp.toIpPrefix()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().group(groupId).build();
        RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)deviceId, (TrafficSelector)selector, (TrafficTreatment)treatment, (ForwardingObjective.Flag)ForwardingObjective.Flag.SPECIFIC, (int)30000, (boolean)install);
    }

    static /* synthetic */ ApplicationId access$200(OpenstackRoutingHandler x0) {
        return x0.appId;
    }

    static /* synthetic */ NodeId access$300(OpenstackRoutingHandler x0) {
        return x0.localNodeId;
    }

    static /* synthetic */ Logger access$400(OpenstackRoutingHandler x0) {
        return x0.log;
    }

    static /* synthetic */ ExecutorService access$500(OpenstackRoutingHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$600(OpenstackRoutingHandler x0, Router x1, RouterInterface x2) {
        x0.routerIfaceRemoved(x1, x2);
    }

    static /* synthetic */ void access$700(OpenstackRoutingHandler x0, Router x1, RouterInterface x2) {
        x0.routerIfaceAdded(x1, x2);
    }

    static /* synthetic */ void access$800(OpenstackRoutingHandler x0, Router x1) {
        x0.routerUpdated(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsRouterService(OpenstackRouterService openstackRouterService) {
        this.osRouterService = openstackRouterService;
    }

    protected void unbindOsRouterService(OpenstackRouterService openstackRouterService) {
        if (this.osRouterService == openstackRouterService) {
            this.osRouterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

