/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.openstacknetworking.api.Constants;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterListener;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.impl.OpenstackRoutingFloatingIpHandler;
import org.onosproject.openstacknetworking.impl.RulePopulatorUtil;
import org.onosproject.openstacknode.OpenstackNodeListener;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackRoutingFloatingIpHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_FLOW = "Failed set flows for floating IP %s: ";
    private static final String ERR_UNSUPPORTED_NET_TYPE = "Unsupported network type";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InstancePortService instancePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackRouterService osRouterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final OpenstackRouterListener floatingIpLisener = new InternalFloatingIpLisener(this, null);
    private final OpenstackNodeListener osNodeListener = new InternalNodeListener(this, null);
    private ApplicationId appId;
    private NodeId localNodeId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.runForLeadership(this.appId.name());
        this.osRouterService.addListener((EventListener)this.floatingIpLisener);
        this.osNodeService.addListener((EventListener)this.osNodeListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osNodeService.removeListener((EventListener)this.osNodeListener);
        this.osRouterService.removeListener((EventListener)this.floatingIpLisener);
        this.leadershipService.withdraw(this.appId.name());
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void setFloatingIpRules(NetFloatingIP floatingIp, Port osPort, boolean install) {
        Network osNet = this.osNetworkService.network(osPort.getNetworkId());
        if (osNet == null) {
            String error = String.format("Failed set flows for floating IP %s: no network(%s) exists", floatingIp.getFloatingIpAddress(), osPort.getNetworkId());
            throw new IllegalStateException(error);
        }
        MacAddress srcMac = MacAddress.valueOf((String)osPort.getMacAddress());
        InstancePort instPort = this.instancePortService.instancePort(srcMac);
        if (instPort == null) {
            String error = String.format("Failed set flows for floating IP %s: no host(MAC:%s) found", floatingIp.getFloatingIpAddress(), srcMac);
            throw new IllegalStateException(error);
        }
        this.setDownstreamRules(floatingIp, osNet, instPort, install);
        this.setUpstreamRules(floatingIp, osNet, instPort, install);
    }

    private void setDownstreamRules(NetFloatingIP floatingIp, Network osNet, InstancePort instPort, boolean install) {
        Optional dataIp = this.osNodeService.dataIp(instPort.deviceId());
        if (!dataIp.isPresent()) {
            this.log.warn("Failed set flows for floating IP %s: compute node {} is not ready", (Object)floatingIp, (Object)instPort.deviceId());
            return;
        }
        IpAddress floating = IpAddress.valueOf((String)floatingIp.getFloatingIpAddress());
        TrafficSelector externalSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(floating.toIpPrefix()).build();
        this.osNodeService.gatewayDeviceIds().forEach(gnodeId -> {
            TrafficTreatment.Builder externalBuilder = DefaultTrafficTreatment.builder().setEthSrc(Constants.DEFAULT_GATEWAY_MAC).setEthDst(instPort.macAddress()).setIpDst((IpAddress)instPort.ipAddress().getIp4Address());
            switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[osNet.getNetworkType().ordinal()]) {
                case 1: {
                    externalBuilder.setTunnelId(Long.valueOf(osNet.getProviderSegID()).longValue()).extension(RulePopulatorUtil.buildExtension((DeviceService)this.deviceService, (DeviceId)gnodeId, (Ip4Address)((IpAddress)dataIp.get()).getIp4Address()), gnodeId).setOutput((PortNumber)this.osNodeService.tunnelPort(gnodeId).get());
                    break;
                }
                case 2: {
                    externalBuilder.pushVlan().setVlanId(VlanId.vlanId((String)osNet.getProviderSegID())).setOutput((PortNumber)this.osNodeService.vlanPort(gnodeId).get());
                    break;
                }
                default: {
                    String error = String.format("Unsupported network type%s", osNet.getNetworkType().toString());
                    throw new IllegalStateException(error);
                }
            }
            RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)gnodeId, (TrafficSelector)externalSelector, (TrafficTreatment)externalBuilder.build(), (ForwardingObjective.Flag)ForwardingObjective.Flag.VERSATILE, (int)41000, (boolean)install);
            TrafficSelector internalSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(floating.toIpPrefix()).matchInPort((PortNumber)this.osNodeService.tunnelPort(gnodeId).get()).build();
            TrafficTreatment.Builder internalBuilder = DefaultTrafficTreatment.builder().setEthSrc(Constants.DEFAULT_GATEWAY_MAC).setEthDst(instPort.macAddress()).setIpDst((IpAddress)instPort.ipAddress().getIp4Address());
            switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[osNet.getNetworkType().ordinal()]) {
                case 1: {
                    internalBuilder.setTunnelId(Long.valueOf(osNet.getProviderSegID()).longValue()).extension(RulePopulatorUtil.buildExtension((DeviceService)this.deviceService, (DeviceId)gnodeId, (Ip4Address)((IpAddress)dataIp.get()).getIp4Address()), gnodeId).setOutput(PortNumber.IN_PORT);
                    break;
                }
                case 2: {
                    internalBuilder.pushVlan().setVlanId(VlanId.vlanId((String)osNet.getProviderSegID())).setOutput(PortNumber.IN_PORT);
                    break;
                }
                default: {
                    String error = String.format("Unsupported network type%s", osNet.getNetworkType().toString());
                    throw new IllegalStateException(error);
                }
            }
            RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)gnodeId, (TrafficSelector)internalSelector, (TrafficTreatment)internalBuilder.build(), (ForwardingObjective.Flag)ForwardingObjective.Flag.VERSATILE, (int)42000, (boolean)install);
        });
    }

    private void setUpstreamRules(NetFloatingIP floatingIp, Network osNet, InstancePort instPort, boolean install) {
        IpAddress floating = IpAddress.valueOf((String)floatingIp.getFloatingIpAddress());
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(instPort.ipAddress().toIpPrefix());
        switch (1.$SwitchMap$org$openstack4j$model$network$NetworkType[osNet.getNetworkType().ordinal()]) {
            case 1: {
                sBuilder.matchTunnelId(Long.valueOf(osNet.getProviderSegID()).longValue());
                break;
            }
            case 2: {
                sBuilder.matchVlanId(VlanId.vlanId((String)osNet.getProviderSegID()));
                break;
            }
            default: {
                String error = String.format("Unsupported network type%s", osNet.getNetworkType().toString());
                throw new IllegalStateException(error);
            }
        }
        this.osNodeService.gatewayDeviceIds().forEach(gnodeId -> {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder().setIpSrc((IpAddress)floating.getIp4Address()).setEthSrc(Constants.DEFAULT_GATEWAY_MAC).setEthDst(Constants.DEFAULT_EXTERNAL_ROUTER_MAC);
            if (osNet.getNetworkType().equals((Object)NetworkType.VLAN)) {
                tBuilder.popVlan();
            }
            RulePopulatorUtil.setRule((FlowObjectiveService)this.flowObjectiveService, (ApplicationId)this.appId, (DeviceId)gnodeId, (TrafficSelector)sBuilder.build(), (TrafficTreatment)tBuilder.setOutput((PortNumber)this.osNodeService.externalPort(gnodeId).get()).build(), (ForwardingObjective.Flag)ForwardingObjective.Flag.VERSATILE, (int)41000, (boolean)install);
        });
    }

    static /* synthetic */ ApplicationId access$200(OpenstackRoutingFloatingIpHandler x0) {
        return x0.appId;
    }

    static /* synthetic */ NodeId access$300(OpenstackRoutingFloatingIpHandler x0) {
        return x0.localNodeId;
    }

    static /* synthetic */ ExecutorService access$400(OpenstackRoutingFloatingIpHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$500(OpenstackRoutingFloatingIpHandler x0, NetFloatingIP x1, Port x2, boolean x3) {
        x0.setFloatingIpRules(x1, x2, x3);
    }

    static /* synthetic */ Logger access$600(OpenstackRoutingFloatingIpHandler x0) {
        return x0.log;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }

    protected void bindInstancePortService(InstancePortService instancePortService) {
        this.instancePortService = instancePortService;
    }

    protected void unbindInstancePortService(InstancePortService instancePortService) {
        if (this.instancePortService == instancePortService) {
            this.instancePortService = null;
        }
    }

    protected void bindOsRouterService(OpenstackRouterService openstackRouterService) {
        this.osRouterService = openstackRouterService;
    }

    protected void unbindOsRouterService(OpenstackRouterService openstackRouterService) {
        if (this.osRouterService == openstackRouterService) {
            this.osRouterService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }
}

