/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.openstacknetworking.api.Constants;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.impl.OpenstackRoutingArpHandler;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenstackRoutingArpHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEVICE_OWNER_ROUTER_GW = "network:router_gateway";
    private static final String DEVICE_OWNER_FLOATING_IP = "network:floatingip";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor(this, null);

    @Activate
    protected void activate() {
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)1));
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    private void processArpPacket(PacketContext context, Ethernet ethernet) {
        Ip4Address targetIp;
        ARP arp = (ARP)ethernet.getPayload();
        if (arp.getOpCode() != 1) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("ARP request received from {} for {}", (Object)Ip4Address.valueOf((byte[])arp.getSenderProtocolAddress()).toString(), (Object)Ip4Address.valueOf((byte[])arp.getTargetProtocolAddress()).toString());
        }
        if (!this.isServiceIp((IpAddress)(targetIp = Ip4Address.valueOf((byte[])arp.getTargetProtocolAddress())).getIp4Address())) {
            this.log.trace("Unknown target ARP request for {}, ignore it", (Object)targetIp);
            return;
        }
        MacAddress targetMac = Constants.DEFAULT_EXTERNAL_ROUTER_MAC;
        Ethernet ethReply = ARP.buildArpReply((Ip4Address)targetIp.getIp4Address(), (MacAddress)targetMac, (Ethernet)ethernet);
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(context.inPacket().receivedFrom().port()).build();
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(context.inPacket().receivedFrom().deviceId(), treatment, ByteBuffer.wrap(ethReply.serialize())));
        context.block();
    }

    private boolean isServiceIp(IpAddress targetIp) {
        return this.osNetworkService.ports().stream().filter(osPort -> Objects.equals(osPort.getDeviceOwner(), DEVICE_OWNER_ROUTER_GW) || Objects.equals(osPort.getDeviceOwner(), DEVICE_OWNER_FLOATING_IP)).flatMap(osPort -> osPort.getFixedIps().stream()).anyMatch(ip -> IpAddress.valueOf((String)ip.getIpAddress()).equals((Object)targetIp));
    }

    static /* synthetic */ ExecutorService access$100(OpenstackRoutingArpHandler x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$200(OpenstackRoutingArpHandler x0, PacketContext x1, Ethernet x2) {
        x0.processArpPacket(x1, x2);
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }
}

