/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.CoreService;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.openstacknetworking.api.OpenstackRouterAdminService;
import org.onosproject.openstacknetworking.api.OpenstackRouterEvent;
import org.onosproject.openstacknetworking.api.OpenstackRouterListener;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.api.OpenstackRouterStore;
import org.onosproject.openstacknetworking.api.OpenstackRouterStoreDelegate;
import org.onosproject.openstacknetworking.impl.OpenstackRouterManager;
import org.onosproject.store.StoreDelegate;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class OpenstackRouterManager
extends ListenerRegistry<OpenstackRouterEvent, OpenstackRouterListener>
implements OpenstackRouterAdminService,
OpenstackRouterService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_ROUTER = "OpenStack router %s %s";
    private static final String MSG_ROUTER_IFACE = "OpenStack router interface %s %s";
    private static final String MSG_FLOATING_IP = "OpenStack floating IP %s %s";
    private static final String MSG_CREATED = "created";
    private static final String MSG_UPDATED = "updated";
    private static final String MSG_REMOVED = "removed";
    private static final String ERR_NULL_ROUTER = "OpenStack router cannot be null";
    private static final String ERR_NULL_ROUTER_ID = "OpenStack router ID cannot be null";
    private static final String ERR_NULL_ROUTER_NAME = "OpenStack router name cannot be null";
    private static final String ERR_NULL_IFACE = "OpenStack router interface cannot be null";
    private static final String ERR_NULL_IFACE_ROUTER_ID = "OpenStack router interface router ID cannot be null";
    private static final String ERR_NULL_IFACE_PORT_ID = "OpenStack router interface port ID cannot be null";
    private static final String ERR_NULL_FLOATING = "OpenStack floating IP cannot be null";
    private static final String ERR_NULL_FLOATING_ID = "OpenStack floating IP cannot be null";
    private static final String ERR_IN_USE = " still in use";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackRouterStore osRouterStore;
    private final OpenstackRouterStoreDelegate delegate = new InternalRouterStoreDelegate(this, null);

    @Activate
    protected void activate() {
        this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osRouterStore.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osRouterStore.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
    }

    public void createRouter(Router osRouter) {
        Preconditions.checkNotNull((Object)osRouter, (Object)ERR_NULL_ROUTER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osRouter.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osRouter.getName()) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_NAME);
        this.osRouterStore.createRouter(osRouter);
        this.log.info(String.format(MSG_ROUTER, osRouter.getName(), MSG_CREATED));
    }

    public void updateRouter(Router osRouter) {
        Preconditions.checkNotNull((Object)osRouter, (Object)ERR_NULL_ROUTER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osRouter.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osRouter.getName()) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_NAME);
        this.osRouterStore.updateRouter(osRouter);
        this.log.info(String.format(MSG_ROUTER, osRouter.getId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRouter(String routerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routerId) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_ID);
        OpenstackRouterManager openstackRouterManager = this;
        synchronized (openstackRouterManager) {
            if (this.isRouterInUse(routerId)) {
                String error = String.format(MSG_ROUTER, routerId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            Router osRouter = this.osRouterStore.removeRouter(routerId);
            if (osRouter != null) {
                this.log.info(String.format(MSG_ROUTER, osRouter.getName(), MSG_REMOVED));
            }
        }
    }

    public void addRouterInterface(RouterInterface osIface) {
        Preconditions.checkNotNull((Object)osIface, (Object)ERR_NULL_IFACE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIface.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_ROUTER_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIface.getPortId()) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_PORT_ID);
        this.osRouterStore.addRouterInterface(osIface);
        this.log.info(String.format(MSG_ROUTER_IFACE, osIface.getPortId(), MSG_CREATED));
    }

    public void updateRouterInterface(RouterInterface osIface) {
        Preconditions.checkNotNull((Object)osIface, (Object)ERR_NULL_IFACE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIface.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_ROUTER_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIface.getPortId()) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_PORT_ID);
        this.osRouterStore.updateRouterInterface(osIface);
        this.log.info(String.format(MSG_ROUTER_IFACE, osIface.getPortId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRouterInterface(String osIfaceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIfaceId) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_PORT_ID);
        OpenstackRouterManager openstackRouterManager = this;
        synchronized (openstackRouterManager) {
            if (this.isRouterIfaceInUse(osIfaceId)) {
                String error = String.format(MSG_ROUTER, osIfaceId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            RouterInterface osIface = this.osRouterStore.removeRouterInterface(osIfaceId);
            if (osIface != null) {
                this.log.info(String.format(MSG_ROUTER_IFACE, osIface.getPortId(), MSG_REMOVED));
            }
        }
    }

    public void createFloatingIp(NetFloatingIP osFloatingIp) {
        Preconditions.checkNotNull((Object)osFloatingIp, (Object)"OpenStack floating IP cannot be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osFloatingIp.getId()) ? 1 : 0) != 0, (Object)"OpenStack floating IP cannot be null");
        this.osRouterStore.createFloatingIp(osFloatingIp);
        this.log.info(String.format(MSG_FLOATING_IP, osFloatingIp.getId(), MSG_CREATED));
    }

    public void updateFloatingIp(NetFloatingIP osFloatingIp) {
        Preconditions.checkNotNull((Object)osFloatingIp, (Object)"OpenStack floating IP cannot be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osFloatingIp.getId()) ? 1 : 0) != 0, (Object)"OpenStack floating IP cannot be null");
        this.osRouterStore.updateFloatingIp(osFloatingIp);
        this.log.info(String.format(MSG_FLOATING_IP, osFloatingIp.getId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFloatingIp(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"OpenStack floating IP cannot be null");
        OpenstackRouterManager openstackRouterManager = this;
        synchronized (openstackRouterManager) {
            if (this.isFloatingIpInUse(floatingIpId)) {
                String error = String.format(MSG_FLOATING_IP, floatingIpId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            NetFloatingIP osFloatingIp = this.osRouterStore.removeFloatingIp(floatingIpId);
            if (osFloatingIp != null) {
                this.log.info(String.format(MSG_FLOATING_IP, osFloatingIp.getId(), MSG_REMOVED));
            }
        }
    }

    public void clear() {
        this.osRouterStore.clear();
    }

    public Router router(String routerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routerId) ? 1 : 0) != 0, (Object)ERR_NULL_ROUTER_ID);
        return this.osRouterStore.router(routerId);
    }

    public Set<Router> routers() {
        return this.osRouterStore.routers();
    }

    public RouterInterface routerInterface(String osIfaceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osIfaceId) ? 1 : 0) != 0, (Object)ERR_NULL_IFACE_PORT_ID);
        return this.osRouterStore.routerInterface(osIfaceId);
    }

    public Set<RouterInterface> routerInterfaces() {
        return this.osRouterStore.routerInterfaces();
    }

    public Set<RouterInterface> routerInterfaces(String routerId) {
        Set osIfaces = this.osRouterStore.routerInterfaces().stream().filter(iface -> Objects.equals(iface.getId(), routerId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osIfaces);
    }

    public NetFloatingIP floatingIp(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"OpenStack floating IP cannot be null");
        return this.osRouterStore.floatingIp(floatingIpId);
    }

    public Set<NetFloatingIP> floatingIps() {
        return this.osRouterStore.floatingIps();
    }

    public Set<NetFloatingIP> floatingIps(String routerId) {
        Set osFloatingIps = this.osRouterStore.floatingIps().stream().filter(fip -> Objects.equals(fip.getRouterId(), routerId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osFloatingIps);
    }

    private boolean isRouterInUse(String routerId) {
        return false;
    }

    private boolean isRouterIfaceInUse(String osIfaceId) {
        return false;
    }

    private boolean isFloatingIpInUse(String floatingIpId) {
        return false;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindOsRouterStore(OpenstackRouterStore openstackRouterStore) {
        this.osRouterStore = openstackRouterStore;
    }

    protected void unbindOsRouterStore(OpenstackRouterStore openstackRouterStore) {
        if (this.osRouterStore == openstackRouterStore) {
            this.osRouterStore = null;
        }
    }
}

