/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.CoreService;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.Port;
import org.onosproject.openstacknetworking.api.OpenstackNetworkAdminService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkEvent;
import org.onosproject.openstacknetworking.api.OpenstackNetworkListener;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkStore;
import org.onosproject.openstacknetworking.api.OpenstackNetworkStoreDelegate;
import org.onosproject.openstacknetworking.impl.OpenstackNetworkManager;
import org.onosproject.store.StoreDelegate;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class OpenstackNetworkManager
extends ListenerRegistry<OpenstackNetworkEvent, OpenstackNetworkListener>
implements OpenstackNetworkAdminService,
OpenstackNetworkService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_NETWORK = "OpenStack network %s %s";
    private static final String MSG_SUBNET = "OpenStack subnet %s %s";
    private static final String MSG_PORT = "OpenStack port %s %s";
    private static final String MSG_CREATED = "created";
    private static final String MSG_UPDATED = "updated";
    private static final String MSG_REMOVED = "removed";
    private static final String ERR_NULL_NETWORK = "OpenStack network cannot be null";
    private static final String ERR_NULL_NETWORK_ID = "OpenStack network ID cannot be null";
    private static final String ERR_NULL_NETWORK_NAME = "OpenStack network name cannot be null";
    private static final String ERR_NULL_SUBNET = "OpenStack subnet cannot be null";
    private static final String ERR_NULL_SUBNET_ID = "OpenStack subnet ID cannot be null";
    private static final String ERR_NULL_SUBNET_NET_ID = "OpenStack subnet network ID cannot be null";
    private static final String ERR_NULL_SUBNET_CIDR = "OpenStack subnet CIDR cannot be null";
    private static final String ERR_NULL_PORT = "OpenStack port cannot be null";
    private static final String ERR_NULL_PORT_ID = "OpenStack port ID cannot be null";
    private static final String ERR_NULL_PORT_NET_ID = "OpenStack port network ID cannot be null";
    private static final String ERR_IN_USE = " still in use";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkStore osNetworkStore;
    private final OpenstackNetworkStoreDelegate delegate = new InternalNetworkStoreDelegate(this, null);

    @Activate
    protected void activate() {
        this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osNetworkStore.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osNetworkStore.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
    }

    public void createNetwork(Network osNet) {
        Preconditions.checkNotNull((Object)osNet, (Object)ERR_NULL_NETWORK);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osNet.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osNet.getName()) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_NAME);
        this.osNetworkStore.createNetwork(osNet);
        this.log.info(String.format(MSG_NETWORK, osNet.getName(), MSG_CREATED));
    }

    public void updateNetwork(Network osNet) {
        Preconditions.checkNotNull((Object)osNet, (Object)ERR_NULL_NETWORK);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osNet.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osNet.getName()) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_NAME);
        this.osNetworkStore.updateNetwork(osNet);
        this.log.info(String.format(MSG_NETWORK, osNet.getId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetwork(String netId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)netId) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_ID);
        OpenstackNetworkManager openstackNetworkManager = this;
        synchronized (openstackNetworkManager) {
            if (this.isNetworkInUse(netId)) {
                String error = String.format(MSG_NETWORK, netId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            Network osNet = this.osNetworkStore.removeNetwork(netId);
            if (osNet != null) {
                this.log.info(String.format(MSG_NETWORK, osNet.getName(), MSG_REMOVED));
            }
        }
    }

    public void createSubnet(Subnet osSubnet) {
        Preconditions.checkNotNull((Object)osSubnet, (Object)ERR_NULL_SUBNET);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getNetworkId()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_NET_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getCidr()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_CIDR);
        this.osNetworkStore.createSubnet(osSubnet);
        this.log.info(String.format(MSG_SUBNET, osSubnet.getCidr(), MSG_CREATED));
    }

    public void updateSubnet(Subnet osSubnet) {
        Preconditions.checkNotNull((Object)osSubnet, (Object)ERR_NULL_SUBNET);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getNetworkId()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_NET_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osSubnet.getCidr()) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_CIDR);
        this.osNetworkStore.updateSubnet(osSubnet);
        this.log.info(String.format(MSG_SUBNET, osSubnet.getCidr(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubnet(String subnetId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetId) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_ID);
        OpenstackNetworkManager openstackNetworkManager = this;
        synchronized (openstackNetworkManager) {
            if (this.isSubnetInUse(subnetId)) {
                String error = String.format(MSG_SUBNET, subnetId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            Subnet osSubnet = this.osNetworkStore.removeSubnet(subnetId);
            if (osSubnet != null) {
                this.log.info(String.format(MSG_SUBNET, osSubnet.getCidr(), MSG_REMOVED));
            }
        }
    }

    public void createPort(org.openstack4j.model.network.Port osPort) {
        Preconditions.checkNotNull((Object)osPort, (Object)ERR_NULL_PORT);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osPort.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osPort.getNetworkId()) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_NET_ID);
        this.osNetworkStore.createPort(osPort);
        this.log.info(String.format(MSG_PORT, osPort.getId(), MSG_CREATED));
    }

    public void updatePort(org.openstack4j.model.network.Port osPort) {
        Preconditions.checkNotNull((Object)osPort, (Object)ERR_NULL_PORT);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osPort.getId()) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_ID);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)osPort.getNetworkId()) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_NET_ID);
        this.osNetworkStore.updatePort(osPort);
        this.log.info(String.format(MSG_PORT, osPort.getId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePort(String portId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)portId) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_ID);
        OpenstackNetworkManager openstackNetworkManager = this;
        synchronized (openstackNetworkManager) {
            if (this.isPortInUse(portId)) {
                String error = String.format(MSG_PORT, portId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            org.openstack4j.model.network.Port osPort = this.osNetworkStore.removePort(portId);
            if (osPort != null) {
                this.log.info(String.format(MSG_PORT, osPort.getId(), MSG_REMOVED));
            }
        }
    }

    public void clear() {
        this.osNetworkStore.clear();
    }

    public Network network(String netId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)netId) ? 1 : 0) != 0, (Object)ERR_NULL_NETWORK_ID);
        return this.osNetworkStore.network(netId);
    }

    public Set<Network> networks() {
        return this.osNetworkStore.networks();
    }

    public Subnet subnet(String subnetId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetId) ? 1 : 0) != 0, (Object)ERR_NULL_SUBNET_ID);
        return this.osNetworkStore.subnet(subnetId);
    }

    public Set<Subnet> subnets() {
        return this.osNetworkStore.subnets();
    }

    public Set<Subnet> subnets(String netId) {
        Set osSubnets = this.osNetworkStore.subnets().stream().filter(subnet -> Objects.equals(subnet.getNetworkId(), netId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osSubnets);
    }

    public org.openstack4j.model.network.Port port(String portId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)portId) ? 1 : 0) != 0, (Object)ERR_NULL_PORT_ID);
        return this.osNetworkStore.port(portId);
    }

    public org.openstack4j.model.network.Port port(Port port) {
        String portName = port.annotations().value("portName");
        if (Strings.isNullOrEmpty((String)portName)) {
            return null;
        }
        Optional<org.openstack4j.model.network.Port> osPort = this.osNetworkStore.ports().stream().filter(p -> p.getId().contains(portName.substring(3))).findFirst();
        return osPort.isPresent() ? osPort.get() : null;
    }

    public Set<org.openstack4j.model.network.Port> ports() {
        return this.osNetworkStore.ports();
    }

    public Set<org.openstack4j.model.network.Port> ports(String netId) {
        Set osPorts = this.osNetworkStore.ports().stream().filter(port -> Objects.equals(port.getNetworkId(), netId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osPorts);
    }

    private boolean isNetworkInUse(String netId) {
        return !this.subnets(netId).isEmpty() && !this.ports(netId).isEmpty();
    }

    private boolean isSubnetInUse(String subnetId) {
        return false;
    }

    private boolean isPortInUse(String portId) {
        return false;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindOsNetworkStore(OpenstackNetworkStore openstackNetworkStore) {
        this.osNetworkStore = openstackNetworkStore;
    }

    protected void unbindOsNetworkStore(OpenstackNetworkStore openstackNetworkStore) {
        if (this.osNetworkStore == openstackNetworkStore) {
            this.osNetworkStore = null;
        }
    }
}

