/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.openstacknetworking.api.InstancePort;
import org.onosproject.openstacknetworking.api.InstancePortEvent;
import org.onosproject.openstacknetworking.api.InstancePortListener;
import org.onosproject.openstacknetworking.api.InstancePortService;
import org.onosproject.openstacknetworking.impl.HostBasedInstancePort;
import org.onosproject.openstacknetworking.impl.HostBasedInstancePortManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class HostBasedInstancePortManager
extends ListenerRegistry<InstancePortEvent, InstancePortListener>
implements InstancePortService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    private final HostListener hostListener = new InternalHostListener(this, null);

    @Activate
    protected void activate() {
        this.hostService.addListener((EventListener)this.hostListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.hostService.removeListener((EventListener)this.hostListener);
        this.log.info("Stopped");
    }

    public InstancePort instancePort(MacAddress macAddress) {
        Host host = this.hostService.getHost(HostId.hostId((MacAddress)macAddress));
        if (host == null || !this.isValidHost(host)) {
            return null;
        }
        return HostBasedInstancePort.of((Host)host);
    }

    public InstancePort instancePort(IpAddress ipAddress, String osNetId) {
        return Tools.stream((Iterable)this.hostService.getHosts()).filter(arg_0 -> this.isValidHost(arg_0)).map(HostBasedInstancePort::of).filter(instPort -> instPort.networkId().equals(osNetId)).filter(instPort -> instPort.ipAddress().equals((Object)ipAddress)).findAny().orElse(null);
    }

    public InstancePort instancePort(String osPortId) {
        return Tools.stream((Iterable)this.hostService.getHosts()).filter(arg_0 -> this.isValidHost(arg_0)).map(HostBasedInstancePort::of).filter(instPort -> instPort.portId().equals(osPortId)).findAny().orElse(null);
    }

    public Set<InstancePort> instancePorts() {
        Set instPors = Tools.stream((Iterable)this.hostService.getHosts()).filter(arg_0 -> this.isValidHost(arg_0)).map(HostBasedInstancePort::of).collect(Collectors.toSet());
        return ImmutableSet.copyOf(instPors);
    }

    public Set<InstancePort> instancePorts(String osNetId) {
        Set instPors = Tools.stream((Iterable)this.hostService.getHosts()).filter(arg_0 -> this.isValidHost(arg_0)).map(HostBasedInstancePort::of).filter(instPort -> instPort.networkId().equals(osNetId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(instPors);
    }

    private boolean isValidHost(Host host) {
        return !host.ipAddresses().isEmpty() && host.annotations().value("networkId") != null && host.annotations().value("portId") != null;
    }

    static /* synthetic */ boolean access$100(HostBasedInstancePortManager x0, Host x1) {
        return x0.isValidHost(x1);
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }
}

