/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.PortNumber;
import org.onosproject.openstacknetworking.api.InstancePort;

public final class HostBasedInstancePort
implements InstancePort {
    static final String ANNOTATION_NETWORK_ID = "networkId";
    static final String ANNOTATION_PORT_ID = "portId";
    static final String ANNOTATION_CREATE_TIME = "createTime";
    private final Host host;

    private HostBasedInstancePort(Host instance) {
        this.host = instance;
    }

    public static HostBasedInstancePort of(Host host) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host.annotations().value(ANNOTATION_NETWORK_ID)) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host.annotations().value(ANNOTATION_PORT_ID)) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host.annotations().value(ANNOTATION_CREATE_TIME)) ? 1 : 0) != 0);
        return new HostBasedInstancePort(host);
    }

    public String networkId() {
        return this.host.annotations().value(ANNOTATION_NETWORK_ID);
    }

    public String portId() {
        return this.host.annotations().value(ANNOTATION_PORT_ID);
    }

    public MacAddress macAddress() {
        return this.host.mac();
    }

    public IpAddress ipAddress() {
        Optional ipAddr = this.host.ipAddresses().stream().findFirst();
        return ipAddr.orElse(null);
    }

    public DeviceId deviceId() {
        return this.host.location().deviceId();
    }

    public PortNumber portNumber() {
        return this.host.location().port();
    }

    public String toString() {
        return this.host.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HostBasedInstancePort) {
            HostBasedInstancePort that = (HostBasedInstancePort)obj;
            if (Objects.equals(this.portId(), that.portId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.portId());
    }
}

