/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupEvent;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupStore;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupStoreDelegate;
import org.onosproject.openstacknetworking.impl.DistributedSecurityGroupStore;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroup;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class DistributedSecurityGroupStore
extends AbstractStore<OpenstackSecurityGroupEvent, OpenstackSecurityGroupStoreDelegate>
implements OpenstackSecurityGroupStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_NOT_FOUND = " does not exist";
    private static final String ERR_DUPLICATE = " already exists";
    private static final KryoNamespace SERIALIZER_SECURITY_GROUP = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{SecurityGroup.class}).register(new Class[]{SecurityGroupRule.class}).register(new Class[]{NeutronSecurityGroupRule.class}).register(new Class[]{NeutronSecurityGroup.class}).build();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final MapEventListener<String, SecurityGroup> securityGroupMapListener = new OpenstackSecurityGroupMapListener(this, null);
    private ConsistentMap<String, SecurityGroup> osSecurityGroupStore;

    @Activate
    protected void activate() {
        ApplicationId appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osSecurityGroupStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_SECURITY_GROUP))).withName("openstack-securitygroupstore")).withApplicationId(appId)).build();
        this.osSecurityGroupStore.addListener(this.securityGroupMapListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osSecurityGroupStore.removeListener(this.securityGroupMapListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    public void createSecurityGroup(SecurityGroup sg) {
        this.osSecurityGroupStore.compute((Object)sg.getId(), (id, existing) -> {
            String error = sg.getName() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return sg;
        });
    }

    public void updateSecurityGroup(SecurityGroup sg) {
        this.osSecurityGroupStore.compute((Object)sg.getId(), (id, existing) -> {
            String error = sg.getName() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return sg;
        });
    }

    public SecurityGroup removeSecurityGroup(String sgId) {
        Versioned sg = this.osSecurityGroupStore.remove((Object)sgId);
        return sg == null ? null : (SecurityGroup)sg.value();
    }

    public SecurityGroup securityGroup(String sgId) {
        Versioned osSg = this.osSecurityGroupStore.get((Object)sgId);
        return osSg == null ? null : (SecurityGroup)osSg.value();
    }

    public Set<SecurityGroup> securityGroups() {
        Set osSgs = this.osSecurityGroupStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osSgs);
    }

    public void clear() {
        this.osSecurityGroupStore.clear();
    }

    static /* synthetic */ ExecutorService access$100(DistributedSecurityGroupStore x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$200(DistributedSecurityGroupStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$300(DistributedSecurityGroupStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$400(DistributedSecurityGroupStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$500(DistributedSecurityGroupStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

