/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.openstacknetworking.api.OpenstackRouterEvent;
import org.onosproject.openstacknetworking.api.OpenstackRouterStore;
import org.onosproject.openstacknetworking.api.OpenstackRouterStoreDelegate;
import org.onosproject.openstacknetworking.impl.DistributedOpenstackRouterStore;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.openstack4j.model.network.ExternalGateway;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.State;
import org.openstack4j.openstack.networking.domain.NeutronExternalGateway;
import org.openstack4j.openstack.networking.domain.NeutronFloatingIP;
import org.openstack4j.openstack.networking.domain.NeutronHostRoute;
import org.openstack4j.openstack.networking.domain.NeutronRouter;
import org.openstack4j.openstack.networking.domain.NeutronRouterInterface;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class DistributedOpenstackRouterStore
extends AbstractStore<OpenstackRouterEvent, OpenstackRouterStoreDelegate>
implements OpenstackRouterStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_NOT_FOUND = " does not exist";
    private static final String ERR_DUPLICATE = " already exists";
    private static final KryoNamespace SERIALIZER_NEUTRON_L3 = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Router.class}).register(new Class[]{NeutronRouter.class}).register(new Class[]{State.class}).register(new Class[]{NeutronHostRoute.class}).register(new Class[]{ExternalGateway.class}).register(new Class[]{NeutronExternalGateway.class}).register(new Class[]{RouterInterface.class}).register(new Class[]{NeutronRouterInterface.class}).register(new Class[]{NetFloatingIP.class}).register(new Class[]{NeutronFloatingIP.class}).build();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final MapEventListener<String, Router> routerMapListener = new OpenstackRouterMapListener(this, null);
    private final MapEventListener<String, RouterInterface> routerInterfaceMapListener = new OpenstackRouterInterfaceMapListener(this, null);
    private final MapEventListener<String, NetFloatingIP> floatingIpMapListener = new OpenstackFloatingIpMapListener(this, null);
    private ConsistentMap<String, Router> osRouterStore;
    private ConsistentMap<String, RouterInterface> osRouterInterfaceStore;
    private ConsistentMap<String, NetFloatingIP> osFloatingIpStore;

    @Activate
    protected void activate() {
        ApplicationId appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osRouterStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L3))).withName("openstack-routerstore")).withApplicationId(appId)).build();
        this.osRouterStore.addListener(this.routerMapListener);
        this.osRouterInterfaceStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L3))).withName("openstack-routerifacestore")).withApplicationId(appId)).build();
        this.osRouterInterfaceStore.addListener(this.routerInterfaceMapListener);
        this.osFloatingIpStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L3))).withName("openstack-floatingipstore")).withApplicationId(appId)).build();
        this.osFloatingIpStore.addListener(this.floatingIpMapListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osRouterStore.removeListener(this.routerMapListener);
        this.osRouterInterfaceStore.removeListener(this.routerInterfaceMapListener);
        this.osFloatingIpStore.removeListener(this.floatingIpMapListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    public void createRouter(Router osRouter) {
        this.osRouterStore.compute((Object)osRouter.getId(), (id, existing) -> {
            String error = osRouter.getName() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osRouter;
        });
    }

    public void updateRouter(Router osRouter) {
        this.osRouterStore.compute((Object)osRouter.getId(), (id, existing) -> {
            String error = osRouter.getName() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osRouter;
        });
    }

    public Router removeRouter(String routerId) {
        Versioned osRouter = this.osRouterStore.remove((Object)routerId);
        return osRouter == null ? null : (Router)osRouter.value();
    }

    public Router router(String routerId) {
        Versioned versioned = this.osRouterStore.get((Object)routerId);
        return versioned == null ? null : (Router)versioned.value();
    }

    public Set<Router> routers() {
        Set osRouters = this.osRouterStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osRouters);
    }

    public void addRouterInterface(RouterInterface osRouterIface) {
        this.osRouterInterfaceStore.compute((Object)osRouterIface.getPortId(), (id, existing) -> {
            String error = osRouterIface.getPortId() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osRouterIface;
        });
    }

    public void updateRouterInterface(RouterInterface osRouterIface) {
        this.osRouterInterfaceStore.compute((Object)osRouterIface.getPortId(), (id, existing) -> {
            String error = osRouterIface.getPortId() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osRouterIface;
        });
    }

    public RouterInterface removeRouterInterface(String routerIfaceId) {
        Versioned osRouterIface = this.osRouterInterfaceStore.remove((Object)routerIfaceId);
        return osRouterIface == null ? null : (RouterInterface)osRouterIface.value();
    }

    public RouterInterface routerInterface(String routerIfaceId) {
        Versioned osRouterIface = this.osRouterInterfaceStore.get((Object)routerIfaceId);
        return osRouterIface == null ? null : (RouterInterface)osRouterIface.value();
    }

    public Set<RouterInterface> routerInterfaces() {
        Set osRouterIfaces = this.osRouterInterfaceStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osRouterIfaces);
    }

    public void createFloatingIp(NetFloatingIP osFloatingIp) {
        this.osFloatingIpStore.compute((Object)osFloatingIp.getId(), (id, existing) -> {
            String error = osFloatingIp.getId() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osFloatingIp;
        });
    }

    public void updateFloatingIp(NetFloatingIP osFloatingIp) {
        this.osFloatingIpStore.compute((Object)osFloatingIp.getId(), (id, existing) -> {
            String error = osFloatingIp.getId() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osFloatingIp;
        });
    }

    public NetFloatingIP removeFloatingIp(String floatingIpId) {
        Versioned osFloatingIp = this.osFloatingIpStore.remove((Object)floatingIpId);
        return osFloatingIp == null ? null : (NetFloatingIP)osFloatingIp.value();
    }

    public NetFloatingIP floatingIp(String floatingIpId) {
        Versioned osFloatingIp = this.osFloatingIpStore.get((Object)floatingIpId);
        return osFloatingIp == null ? null : (NetFloatingIP)osFloatingIp.value();
    }

    public Set<NetFloatingIP> floatingIps() {
        Set osFloatingIps = this.osFloatingIpStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osFloatingIps);
    }

    public void clear() {
        this.osFloatingIpStore.clear();
        this.osRouterInterfaceStore.clear();
        this.osRouterStore.clear();
    }

    static /* synthetic */ ExecutorService access$300(DistributedOpenstackRouterStore x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$400(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$500(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$600(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$700(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$800(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$900(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1000(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1100(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1200(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1300(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1400(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1500(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1600(DistributedOpenstackRouterStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

