/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.openstacknetworking.api.OpenstackNetworkEvent;
import org.onosproject.openstacknetworking.api.OpenstackNetworkStore;
import org.onosproject.openstacknetworking.api.OpenstackNetworkStoreDelegate;
import org.onosproject.openstacknetworking.impl.DistributedOpenstackNetworkStore;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.State;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.networking.domain.NeutronAllowedAddressPair;
import org.openstack4j.openstack.networking.domain.NeutronExtraDhcpOptCreate;
import org.openstack4j.openstack.networking.domain.NeutronHostRoute;
import org.openstack4j.openstack.networking.domain.NeutronIP;
import org.openstack4j.openstack.networking.domain.NeutronNetwork;
import org.openstack4j.openstack.networking.domain.NeutronPool;
import org.openstack4j.openstack.networking.domain.NeutronPort;
import org.openstack4j.openstack.networking.domain.NeutronSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class DistributedOpenstackNetworkStore
extends AbstractStore<OpenstackNetworkEvent, OpenstackNetworkStoreDelegate>
implements OpenstackNetworkStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_NOT_FOUND = " does not exist";
    private static final String ERR_DUPLICATE = " already exists";
    private static final KryoNamespace SERIALIZER_NEUTRON_L2 = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Network.class}).register(new Class[]{NeutronNetwork.class}).register(new Class[]{State.class}).register(new Class[]{NetworkType.class}).register(new Class[]{Port.class}).register(new Class[]{NeutronPort.class}).register(new Class[]{NeutronIP.class}).register(new Class[]{NeutronAllowedAddressPair.class}).register(new Class[]{NeutronExtraDhcpOptCreate.class}).register(new Class[]{Subnet.class}).register(new Class[]{NeutronSubnet.class}).register(new Class[]{NeutronPool.class}).register(new Class[]{NeutronHostRoute.class}).register(new Class[]{IPVersionType.class}).build();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final MapEventListener<String, Network> networkMapListener = new OpenstackNetworkMapListener(this, null);
    private final MapEventListener<String, Subnet> subnetMapListener = new OpenstackSubnetMapListener(this, null);
    private final MapEventListener<String, Port> portMapListener = new OpenstackPortMapListener(this, null);
    private ConsistentMap<String, Network> osNetworkStore;
    private ConsistentMap<String, Subnet> osSubnetStore;
    private ConsistentMap<String, Port> osPortStore;

    @Activate
    protected void activate() {
        ApplicationId appId = this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.osNetworkStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L2))).withName("openstack-networkstore")).withApplicationId(appId)).build();
        this.osNetworkStore.addListener(this.networkMapListener);
        this.osSubnetStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L2))).withName("openstack-subnetstore")).withApplicationId(appId)).build();
        this.osSubnetStore.addListener(this.subnetMapListener);
        this.osPortStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_NEUTRON_L2))).withName("openstack-portstore")).withApplicationId(appId)).build();
        this.osPortStore.addListener(this.portMapListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.osNetworkStore.removeListener(this.networkMapListener);
        this.osSubnetStore.removeListener(this.subnetMapListener);
        this.osPortStore.removeListener(this.portMapListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    public void createNetwork(Network osNet) {
        this.osNetworkStore.compute((Object)osNet.getId(), (id, existing) -> {
            String error = osNet.getName() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osNet;
        });
    }

    public void updateNetwork(Network osNet) {
        this.osNetworkStore.compute((Object)osNet.getId(), (id, existing) -> {
            String error = osNet.getName() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osNet;
        });
    }

    public Network removeNetwork(String netId) {
        Versioned osNet = this.osNetworkStore.remove((Object)netId);
        return osNet == null ? null : (Network)osNet.value();
    }

    public Network network(String netId) {
        Versioned versioned = this.osNetworkStore.get((Object)netId);
        return versioned == null ? null : (Network)versioned.value();
    }

    public Set<Network> networks() {
        Set osNets = this.osNetworkStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osNets);
    }

    public void createSubnet(Subnet osSubnet) {
        this.osSubnetStore.compute((Object)osSubnet.getId(), (id, existing) -> {
            String error = osSubnet.getId() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osSubnet;
        });
    }

    public void updateSubnet(Subnet osSubnet) {
        this.osSubnetStore.compute((Object)osSubnet.getId(), (id, existing) -> {
            String error = osSubnet.getId() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osSubnet;
        });
    }

    public Subnet removeSubnet(String subnetId) {
        Versioned osSubnet = this.osSubnetStore.remove((Object)subnetId);
        return osSubnet == null ? null : (Subnet)osSubnet.value();
    }

    public Subnet subnet(String subnetId) {
        Versioned osSubnet = this.osSubnetStore.get((Object)subnetId);
        return osSubnet == null ? null : (Subnet)osSubnet.value();
    }

    public Set<Subnet> subnets() {
        Set osSubnets = this.osSubnetStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osSubnets);
    }

    public void createPort(Port osPort) {
        this.osPortStore.compute((Object)osPort.getId(), (id, existing) -> {
            String error = osPort.getId() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return osPort;
        });
    }

    public void updatePort(Port osPort) {
        this.osPortStore.compute((Object)osPort.getId(), (id, existing) -> {
            String error = osPort.getId() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return osPort;
        });
    }

    public Port removePort(String portId) {
        Versioned osPort = this.osPortStore.remove((Object)portId);
        return osPort == null ? null : (Port)osPort.value();
    }

    public Port port(String portId) {
        Versioned osPort = this.osPortStore.get((Object)portId);
        return osPort == null ? null : (Port)osPort.value();
    }

    public Set<Port> ports() {
        Set osPorts = this.osPortStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(osPorts);
    }

    public void clear() {
        this.osPortStore.clear();
        this.osSubnetStore.clear();
        this.osNetworkStore.clear();
    }

    static /* synthetic */ ExecutorService access$300(DistributedOpenstackNetworkStore x0) {
        return x0.eventExecutor;
    }

    static /* synthetic */ void access$400(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$500(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$600(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$700(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$800(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$900(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1000(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1100(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1200(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1300(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$1400(DistributedOpenstackNetworkStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

