/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackNetworkAdminService;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterAdminService;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupAdminService;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupService;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.identity.Access;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.OSFactory;
import org.openstack4j.openstack.networking.domain.NeutronRouterInterface;

/*
 * Exception performing whole class analysis ignored.
 */
@Command(scope="onos", name="openstack-sync-states", description="Synchronizes all OpenStack network states")
public class OpenstackSyncStateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="endpoint", description="OpenStack service endpoint", required=true, multiValued=false)
    private String endpoint = null;
    @Argument(index=1, name="tenant", description="OpenStack admin tenant name", required=true, multiValued=false)
    private String tenant = null;
    @Argument(index=2, name="user", description="OpenStack admin user name", required=true, multiValued=false)
    private String user = null;
    @Argument(index=3, name="password", description="OpenStack admin user password", required=true, multiValued=false)
    private String password = null;
    private static final String SECURITY_GROUP_FORMAT = "%-40s%-20s";
    private static final String NETWORK_FORMAT = "%-40s%-20s%-20s%-8s";
    private static final String SUBNET_FORMAT = "%-40s%-20s%-20s";
    private static final String PORT_FORMAT = "%-40s%-20s%-20s%-8s";
    private static final String ROUTER_FORMAT = "%-40s%-20s%-20s%-8s";
    private static final String FLOATING_IP_FORMAT = "%-40s%-20s%-20s";
    private static final String DEVICE_OWNER_GW = "network:router_gateway";
    private static final String DEVICE_OWNER_IFACE = "network:router_interface";

    protected void execute() {
        Access osAccess;
        OpenstackSecurityGroupAdminService osSgAdminService = (OpenstackSecurityGroupAdminService)OpenstackSyncStateCommand.get(OpenstackSecurityGroupAdminService.class);
        OpenstackSecurityGroupService osSgService = (OpenstackSecurityGroupService)OpenstackSyncStateCommand.get(OpenstackSecurityGroupService.class);
        OpenstackNetworkAdminService osNetAdminService = (OpenstackNetworkAdminService)OpenstackSyncStateCommand.get(OpenstackNetworkAdminService.class);
        OpenstackNetworkService osNetService = (OpenstackNetworkService)OpenstackSyncStateCommand.get(OpenstackNetworkService.class);
        OpenstackRouterAdminService osRouterAdminService = (OpenstackRouterAdminService)OpenstackSyncStateCommand.get(OpenstackRouterAdminService.class);
        OpenstackRouterService osRouterService = (OpenstackRouterService)OpenstackSyncStateCommand.get(OpenstackRouterService.class);
        try {
            osAccess = ((OSClient)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builder().endpoint(this.endpoint)).tenantName(this.tenant).credentials(this.user, this.password)).authenticate()).getAccess();
        }
        catch (AuthenticationException e) {
            this.print("Authentication failed", new Object[0]);
            return;
        }
        catch (Exception e) {
            this.print("Failed to access OpenStack service", new Object[0]);
            return;
        }
        OSClient osClient = OSFactory.clientFromAccess((Access)osAccess);
        this.print("Synchronizing OpenStack security groups", new Object[0]);
        this.print("%-40s%-20s", new Object[]{"ID", "Name"});
        osClient.networking().securitygroup().list().forEach(osSg -> {
            if (osSgService.securityGroup(osSg.getId()) != null) {
                osSgAdminService.updateSecurityGroup(osSg);
            } else {
                osSgAdminService.createSecurityGroup(osSg);
            }
            this.print("%-40s%-20s", new Object[]{osSg.getId(), osSg.getName()});
        });
        this.print("\nSynchronizing OpenStack networks", new Object[0]);
        this.print("%-40s%-20s%-20s%-8s", new Object[]{"ID", "Name", "VNI", "Subnets"});
        osClient.networking().network().list().forEach(osNet -> {
            if (osNetService.network(osNet.getId()) != null) {
                osNetAdminService.updateNetwork(osNet);
            } else {
                osNetAdminService.createNetwork(osNet);
            }
            this.printNetwork(osNet);
        });
        this.print("\nSynchronizing OpenStack subnets", new Object[0]);
        this.print("%-40s%-20s%-20s", new Object[]{"ID", "Network", "CIDR"});
        osClient.networking().subnet().list().forEach(osSubnet -> {
            if (osNetService.subnet(osSubnet.getId()) != null) {
                osNetAdminService.updateSubnet(osSubnet);
            } else {
                osNetAdminService.createSubnet(osSubnet);
            }
            this.printSubnet(osSubnet, osNetService);
        });
        this.print("\nSynchronizing OpenStack ports", new Object[0]);
        this.print("%-40s%-20s%-20s%-8s", new Object[]{"ID", "Network", "MAC", "Fixed IPs"});
        osClient.networking().port().list().forEach(osPort -> {
            if (osNetService.port(osPort.getId()) != null) {
                osNetAdminService.updatePort(osPort);
            } else {
                osNetAdminService.createPort(osPort);
            }
            this.printPort(osPort, osNetService);
        });
        this.print("\nSynchronizing OpenStack routers", new Object[0]);
        this.print("%-40s%-20s%-20s%-8s", new Object[]{"ID", "Name", "External", "Internal"});
        osClient.networking().router().list().forEach(osRouter -> {
            if (osRouterService.router(osRouter.getId()) != null) {
                osRouterAdminService.updateRouter(osRouter);
            } else {
                osRouterAdminService.createRouter(osRouter);
            }
            osNetService.ports().stream().filter(osPort -> Objects.equals(osPort.getDeviceId(), osRouter.getId()) && Objects.equals(osPort.getDeviceOwner(), "network:router_interface")).forEach(osPort -> this.addRouterIface(osPort, osRouterService, osRouterAdminService));
            this.printRouter(osRouter, osNetService);
        });
        this.print("\nSynchronizing OpenStack floating IPs", new Object[0]);
        this.print("%-40s%-20s%-20s", new Object[]{"ID", "Floating IP", "Fixed IP"});
        osClient.networking().floatingip().list().forEach(osFloating -> {
            if (osRouterService.floatingIp(osFloating.getId()) != null) {
                osRouterAdminService.updateFloatingIp(osFloating);
            } else {
                osRouterAdminService.createFloatingIp(osFloating);
            }
            this.printFloatingIp(osFloating);
        });
    }

    private void addRouterIface(Port osPort, OpenstackRouterService service, OpenstackRouterAdminService adminService) {
        osPort.getFixedIps().forEach(p -> {
            ObjectNode jsonTree = this.mapper().createObjectNode().put("id", osPort.getDeviceId()).put("tenant_id", osPort.getTenantId()).put("subnet_id", p.getSubnetId()).put("port_id", osPort.getId());
            try {
                RouterInterface rIface = (RouterInterface)ObjectMapperSingleton.getContext(NeutronRouterInterface.class).readerFor(NeutronRouterInterface.class).readValue((JsonNode)jsonTree);
                if (service.routerInterface(rIface.getPortId()) != null) {
                    adminService.updateRouterInterface(rIface);
                } else {
                    adminService.addRouterInterface(rIface);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void printNetwork(Network osNet) {
        String strNet = String.format("%-40s%-20s%-20s%-8s", osNet.getId(), osNet.getName(), osNet.getProviderSegID(), osNet.getSubnets());
        this.print(strNet, new Object[0]);
    }

    private void printSubnet(Subnet osSubnet, OpenstackNetworkService osNetService) {
        String strSubnet = String.format("%-40s%-20s%-20s", osSubnet.getId(), osNetService.network(osSubnet.getNetworkId()).getName(), osSubnet.getCidr());
        this.print(strSubnet, new Object[0]);
    }

    private void printPort(Port osPort, OpenstackNetworkService osNetService) {
        List fixedIps = osPort.getFixedIps().stream().map(IP::getIpAddress).collect(Collectors.toList());
        String strPort = String.format("%-40s%-20s%-20s%-8s", osPort.getId(), osNetService.network(osPort.getNetworkId()).getName(), osPort.getMacAddress(), fixedIps.isEmpty() ? "" : fixedIps);
        this.print(strPort, new Object[0]);
    }

    private void printRouter(Router osRouter, OpenstackNetworkService osNetService) {
        List externals = osNetService.ports().stream().filter(osPort -> Objects.equals(osPort.getDeviceId(), osRouter.getId()) && Objects.equals(osPort.getDeviceOwner(), "network:router_gateway")).flatMap(osPort -> osPort.getFixedIps().stream()).map(IP::getIpAddress).collect(Collectors.toList());
        List internals = osNetService.ports().stream().filter(osPort -> Objects.equals(osPort.getDeviceId(), osRouter.getId()) && Objects.equals(osPort.getDeviceOwner(), "network:router_interface")).flatMap(osPort -> osPort.getFixedIps().stream()).map(IP::getIpAddress).collect(Collectors.toList());
        String strRouter = String.format("%-40s%-20s%-20s%-8s", osRouter.getId(), osRouter.getName(), externals.isEmpty() ? "" : externals, internals.isEmpty() ? "" : internals);
        this.print(strRouter, new Object[0]);
    }

    private void printFloatingIp(NetFloatingIP floatingIp) {
        String strFloating = String.format("%-40s%-20s%-20s", floatingIp.getId(), floatingIp.getFixedIpAddress(), Strings.isNullOrEmpty((String)floatingIp.getFixedIpAddress()) ? "" : floatingIp.getFixedIpAddress());
        this.print(strFloating, new Object[0]);
    }
}

