/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupService;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.common.IdEntity;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroup;

@Command(scope="onos", name="openstack-security-groups", description="Lists all OpenStack security groups")
public class OpenstackSecurityGroupListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-40s%-20s";
    @Argument(name="networkId", description="Network ID")
    private String networkId = null;

    protected void execute() {
        OpenstackSecurityGroupService service = (OpenstackSecurityGroupService)AbstractShellCommand.get(OpenstackSecurityGroupService.class);
        ArrayList sgs = Lists.newArrayList((Iterable)service.securityGroups());
        sgs.sort(Comparator.comparing(IdEntity::getId));
        if (this.outputJson()) {
            try {
                this.print("%s", new Object[]{this.mapper().writeValueAsString((Object)this.json((List)sgs))});
            }
            catch (JsonProcessingException e) {
                this.error("Failed to list security groups in JSON format", new Object[0]);
            }
            return;
        }
        this.print("Hint: use --json option to see security group rules as well\n", new Object[0]);
        this.print(FORMAT, new Object[]{"ID", "Name"});
        for (SecurityGroup sg : service.securityGroups()) {
            this.print(FORMAT, new Object[]{sg.getId(), sg.getName()});
        }
    }

    private JsonNode json(List<SecurityGroup> securityGroups) {
        ArrayNode result = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).createArrayNode();
        for (SecurityGroup sg : securityGroups) {
            result.add((JsonNode)this.writeSecurityGroup(sg));
        }
        return result;
    }

    private ObjectNode writeSecurityGroup(SecurityGroup sg) {
        try {
            String strSg = ObjectMapperSingleton.getContext(NeutronSecurityGroup.class).writerFor(NeutronSecurityGroup.class).writeValueAsString((Object)sg);
            return (ObjectNode)this.mapper().readTree(strSg.getBytes());
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

