/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.openstack.networking.domain.NeutronRouter;

@Command(scope="onos", name="openstack-routers", description="Lists all OpenStack routers")
public class OpenstackRouterListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-40s%-20s%-20s%-8s";
    private final OpenstackRouterService routerService = (OpenstackRouterService)AbstractShellCommand.get(OpenstackRouterService.class);
    private final OpenstackNetworkService netService = (OpenstackNetworkService)AbstractShellCommand.get(OpenstackNetworkService.class);

    protected void execute() {
        ArrayList routers = Lists.newArrayList((Iterable)this.routerService.routers());
        routers.sort(Comparator.comparing(BasicResource::getName));
        if (this.outputJson()) {
            try {
                this.print("%s", new Object[]{this.mapper().writeValueAsString((Object)this.json((List)routers))});
            }
            catch (JsonProcessingException e) {
                this.print("Failed to list routers in JSON format", new Object[0]);
            }
            return;
        }
        this.print(FORMAT, new Object[]{"ID", "Name", "External", "Internal"});
        for (Router router : routers) {
            String exNetId = router.getExternalGatewayInfo() != null ? router.getExternalGatewayInfo().getNetworkId() : null;
            List<Object> externals = Lists.newArrayList();
            if (exNetId != null) {
                externals = this.netService.ports(exNetId).stream().filter(port -> Objects.equals(port.getDeviceId(), router.getId())).flatMap(port -> port.getFixedIps().stream()).map(IP::getIpAddress).collect(Collectors.toList());
            }
            ArrayList internals = Lists.newArrayList();
            this.routerService.routerInterfaces(router.getId()).forEach(iface -> internals.add(this.getRouterIfaceIp(iface)));
            this.print(FORMAT, new Object[]{router.getId(), router.getName(), externals, internals});
        }
    }

    private String getRouterIfaceIp(RouterInterface iface) {
        Port osPort = this.netService.port(iface.getPortId());
        IP ipAddr = osPort.getFixedIps().stream().filter(ip -> ip.getSubnetId().equals(iface.getSubnetId())).findAny().orElse(null);
        return ipAddr == null ? "" : ipAddr.getIpAddress();
    }

    private JsonNode json(List<Router> routers) {
        ArrayNode result = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).createArrayNode();
        for (Router router : routers) {
            result.add((JsonNode)this.writeRouter(router));
        }
        return result;
    }

    private ObjectNode writeRouter(Router osRouter) {
        try {
            String strNet = ObjectMapperSingleton.getContext(NeutronRouter.class).writerFor(NeutronRouter.class).writeValueAsString((Object)osRouter);
            return (ObjectNode)this.mapper().readTree(strNet.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }
}

