/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.FlowRuleService;

@Command(scope="onos", name="openstack-purge-rules", description="Purges all flow rules installed by OpenStack networking app")
public class OpenstackPurgeRulesCommand
extends AbstractShellCommand {
    protected void execute() {
        FlowRuleService flowRuleService = (FlowRuleService)AbstractShellCommand.get(FlowRuleService.class);
        CoreService coreService = (CoreService)AbstractShellCommand.get(CoreService.class);
        ApplicationId appId = coreService.getAppId("org.onosproject.openstacknetworking");
        if (appId == null) {
            this.error("Failed to purge OpenStack networking flow rules.", new Object[0]);
            return;
        }
        flowRuleService.removeFlowRulesById(appId);
        this.print("Successfully purged flow rules installed by OpenStack networking application.", new Object[0]);
    }
}

