/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Port;
import org.openstack4j.openstack.networking.domain.NeutronPort;

@Command(scope="onos", name="openstack-ports", description="Lists all OpenStack ports")
public class OpenstackPortListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-40s%-20s%-20s%-8s";
    @Argument(name="networkId", description="Network ID")
    private String networkId = null;

    protected void execute() {
        OpenstackNetworkService service = (OpenstackNetworkService)AbstractShellCommand.get(OpenstackNetworkService.class);
        ArrayList ports = Lists.newArrayList((Iterable)service.ports());
        ports.sort(Comparator.comparing(Port::getNetworkId));
        if (!Strings.isNullOrEmpty((String)this.networkId)) {
            ports.removeIf(port -> !port.getNetworkId().equals(this.networkId));
        }
        if (this.outputJson()) {
            try {
                this.print("%s", new Object[]{this.mapper().writeValueAsString((Object)this.json((List)ports))});
            }
            catch (JsonProcessingException e) {
                this.print("Failed to list ports in JSON format", new Object[0]);
            }
            return;
        }
        this.print(FORMAT, new Object[]{"ID", "Network", "MAC", "Fixed IPs"});
        for (Port port2 : ports) {
            List fixedIps = port2.getFixedIps().stream().map(IP::getIpAddress).collect(Collectors.toList());
            Network osNet = service.network(port2.getNetworkId());
            this.print(FORMAT, new Object[]{port2.getId(), osNet.getName(), port2.getMacAddress(), fixedIps.isEmpty() ? "" : fixedIps});
        }
    }

    private JsonNode json(List<Port> ports) {
        ArrayNode result = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).createArrayNode();
        for (Port port : ports) {
            result.add((JsonNode)this.writePort(port));
        }
        return result;
    }

    private ObjectNode writePort(Port port) {
        try {
            String strPort = ObjectMapperSingleton.getContext(NeutronPort.class).writerFor(NeutronPort.class).writeValueAsString((Object)port);
            return (ObjectNode)this.mapper().readTree(strPort.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }
}

