/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.networking.domain.NeutronNetwork;

@Command(scope="onos", name="openstack-networks", description="Lists all OpenStack networks")
public class OpenstackNetworkListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-40s%-20s%-20s%-20s%-8s";

    protected void execute() {
        OpenstackNetworkService service = (OpenstackNetworkService)AbstractShellCommand.get(OpenstackNetworkService.class);
        ArrayList networks = Lists.newArrayList((Iterable)service.networks());
        networks.sort(Comparator.comparing(BasicResource::getName));
        if (this.outputJson()) {
            try {
                this.print("%s", new Object[]{this.mapper().writeValueAsString((Object)this.json((List)networks))});
            }
            catch (JsonProcessingException e) {
                this.print("Failed to list networks in JSON format", new Object[0]);
            }
            return;
        }
        this.print(FORMAT, new Object[]{"ID", "Name", "Network Mode", "VNI", "Subnets"});
        for (Network net : networks) {
            List subnets = service.subnets().stream().filter(subnet -> subnet.getNetworkId().equals(net.getId())).map(Subnet::getCidr).collect(Collectors.toList());
            this.print(FORMAT, new Object[]{net.getId(), net.getName(), net.getNetworkType().toString(), net.getProviderSegID(), subnets.isEmpty() ? "" : subnets});
        }
    }

    private JsonNode json(List<Network> networks) {
        ArrayNode result = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).createArrayNode();
        for (Network net : networks) {
            result.add((JsonNode)this.writeNetwork(net));
        }
        return result;
    }

    private ObjectNode writeNetwork(Network net) {
        try {
            String strNet = ObjectMapperSingleton.getContext(NeutronNetwork.class).writerFor(NeutronNetwork.class).writeValueAsString((Object)net);
            return (ObjectNode)this.mapper().readTree(strNet.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }
}

