/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknetworking.api.OpenstackRouterService;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.openstack.networking.domain.NeutronFloatingIP;

@Command(scope="onos", name="openstack-floatingips", description="Lists all OpenStack floating IP addresses")
public class OpenstackFloatingIpListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-40s%-20s%-20s";

    protected void execute() {
        OpenstackRouterService service = (OpenstackRouterService)AbstractShellCommand.get(OpenstackRouterService.class);
        ArrayList floatingIps = Lists.newArrayList((Iterable)service.floatingIps());
        floatingIps.sort(Comparator.comparing(NetFloatingIP::getFloatingIpAddress));
        if (this.outputJson()) {
            try {
                this.print("%s", new Object[]{this.mapper().writeValueAsString((Object)this.json((List)floatingIps))});
            }
            catch (JsonProcessingException e) {
                this.print("Failed to list networks in JSON format", new Object[0]);
            }
            return;
        }
        this.print(FORMAT, new Object[]{"ID", "Floating IP", "Fixed IP"});
        for (NetFloatingIP floatingIp : floatingIps) {
            this.print(FORMAT, new Object[]{floatingIp.getId(), floatingIp.getFloatingIpAddress(), Strings.isNullOrEmpty((String)floatingIp.getFixedIpAddress()) ? "" : floatingIp.getFixedIpAddress()});
        }
    }

    private JsonNode json(List<NetFloatingIP> floatingIps) {
        ArrayNode result = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).createArrayNode();
        for (NetFloatingIP floatingIp : floatingIps) {
            result.add((JsonNode)this.writeFloatingIp(floatingIp));
        }
        return result;
    }

    private ObjectNode writeFloatingIp(NetFloatingIP floatingIp) {
        try {
            String strFloatingIp = ObjectMapperSingleton.getContext(NeutronFloatingIP.class).writerFor(NeutronFloatingIP.class).writeValueAsString((Object)floatingIp);
            this.log.trace(strFloatingIp);
            return (ObjectNode)this.mapper().readTree(strFloatingIp.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }
}

