/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.api;

import com.google.common.base.MoreObjects;
import org.joda.time.LocalDateTime;
import org.onosproject.event.AbstractEvent;
import org.onosproject.openstacknetworking.api.OpenstackRouterEvent;
import org.openstack4j.model.network.ExternalGateway;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;

public class OpenstackRouterEvent
extends AbstractEvent<Type, Router> {
    private final ExternalGateway exGateway;
    private final RouterInterface routerIface;
    private final NetFloatingIP floatingIP;
    private final String portId;

    public OpenstackRouterEvent(Type type, Router osRouter) {
        super((Enum)type, (Object)osRouter);
        this.exGateway = null;
        this.routerIface = null;
        this.floatingIP = null;
        this.portId = null;
    }

    public OpenstackRouterEvent(Type type, Router osRouter, ExternalGateway exGateway) {
        super((Enum)type, (Object)osRouter);
        this.exGateway = exGateway;
        this.routerIface = null;
        this.floatingIP = null;
        this.portId = null;
    }

    public OpenstackRouterEvent(Type type, Router osRouter, RouterInterface osRouterIface) {
        super((Enum)type, (Object)osRouter);
        this.exGateway = null;
        this.routerIface = osRouterIface;
        this.floatingIP = null;
        this.portId = null;
    }

    public OpenstackRouterEvent(Type type, Router router, NetFloatingIP floatingIP) {
        super((Enum)type, (Object)router);
        this.exGateway = null;
        this.routerIface = null;
        this.floatingIP = floatingIP;
        this.portId = null;
    }

    public OpenstackRouterEvent(Type type, Router router, NetFloatingIP floatingIP, String portId) {
        super((Enum)type, (Object)router);
        this.exGateway = null;
        this.routerIface = null;
        this.floatingIP = floatingIP;
        this.portId = portId;
    }

    public ExternalGateway externalGateway() {
        return this.exGateway;
    }

    public RouterInterface routerIface() {
        return this.routerIface;
    }

    public NetFloatingIP floatingIp() {
        return this.floatingIP;
    }

    public String portId() {
        return this.portId;
    }

    public String toString() {
        if (this.floatingIP == null) {
            return super.toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)new LocalDateTime(this.time())).add("type", (Object)this.type()).add("router", this.subject()).add("externalGateway", (Object)this.exGateway).add("routerIface", (Object)this.routerIface).add("floatingIp", (Object)this.floatingIP).add("portId", (Object)this.portId).toString();
    }
}

