/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.api;

import com.google.common.base.MoreObjects;
import org.joda.time.LocalDateTime;
import org.onosproject.event.AbstractEvent;
import org.onosproject.openstacknetworking.api.OpenstackNetworkEvent;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.Subnet;

public class OpenstackNetworkEvent
extends AbstractEvent<Type, Network> {
    private final Port port;
    private final Subnet subnet;
    private final String securityGroupId;

    public OpenstackNetworkEvent(Type type, Network network) {
        super((Enum)type, (Object)network);
        this.port = null;
        this.subnet = null;
        this.securityGroupId = null;
    }

    public OpenstackNetworkEvent(Type type, Network network, Port port) {
        super((Enum)type, (Object)network);
        this.port = port;
        this.subnet = null;
        this.securityGroupId = null;
    }

    public OpenstackNetworkEvent(Type type, Network network, Subnet subnet) {
        super((Enum)type, (Object)network);
        this.port = null;
        this.subnet = subnet;
        this.securityGroupId = null;
    }

    public OpenstackNetworkEvent(Type type, Port port, String securityGroupId) {
        super((Enum)type, null);
        this.port = port;
        this.subnet = null;
        this.securityGroupId = securityGroupId;
    }

    public Port port() {
        return this.port;
    }

    public Subnet subnet() {
        return this.subnet;
    }

    public String securityGroupId() {
        return this.securityGroupId;
    }

    public String toString() {
        if (this.port == null && this.subnet == null) {
            return super.toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)new LocalDateTime(this.time())).add("type", (Object)this.type()).add("network", this.subject()).add("port", (Object)this.port).add("subnet", (Object)this.subnet).add("security group", (Object)this.securityGroupId()).toString();
    }
}

