/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.Arrays;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.support.IdComparator;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="scr", name="list", description="Display available components")
public class ListAction
extends ScrActionSupport {
    private final IdComparator idComparator = new IdComparator();

    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("State");
        table.column("Component Name");
        Component[] components = scrService.getComponents();
        Arrays.sort(components, this.idComparator);
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            if (this.showHidden) {
                table.addRow().addContent(new Object[]{component.getId(), ScrUtils.getState(component.getState()), component.getName()});
                continue;
            }
            if (ScrActionSupport.isHiddenComponent(component)) continue;
            table.addRow().addContent(new Object[]{component.getId(), ScrUtils.getState(component.getState()), component.getName()});
        }
        table.print(System.out);
        return null;
    }
}

