/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Throwables;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DocumentException;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentDocumentTree<V>
extends Synchronous<AsyncDocumentTree<V>>
implements DocumentTree<V> {
    private final AsyncDocumentTree<V> backingMap;
    private static final int MAX_DELAY_BETWEEN_RETRY_MILLS = 50;
    private final long operationTimeoutMillis;

    public DefaultConsistentDocumentTree(AsyncDocumentTree<V> backingMap, long operationTimeoutMillis) {
        super(backingMap);
        this.backingMap = backingMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    public DocumentPath root() {
        return this.backingMap.root();
    }

    public Map<String, Versioned<V>> getChildren(DocumentPath path) {
        return (Map)this.complete(this.backingMap.getChildren(path));
    }

    public Versioned<V> get(DocumentPath path) {
        return (Versioned)this.complete(this.backingMap.get(path));
    }

    public Versioned<V> set(DocumentPath path, V value) {
        return (Versioned)this.complete(this.backingMap.set(path, value));
    }

    public boolean create(DocumentPath path, V value) {
        return (Boolean)this.complete(this.backingMap.create(path, value));
    }

    public boolean createRecursive(DocumentPath path, V value) {
        return (Boolean)this.complete(this.backingMap.createRecursive(path, value));
    }

    public boolean replace(DocumentPath path, V newValue, long version) {
        return (Boolean)this.complete(this.backingMap.replace(path, newValue, version));
    }

    public boolean replace(DocumentPath path, V newValue, V currentValue) {
        return (Boolean)this.complete(this.backingMap.replace(path, newValue, currentValue));
    }

    public Versioned<V> removeNode(DocumentPath path) {
        return (Versioned)this.complete(this.backingMap.removeNode(path));
    }

    public void addListener(DocumentPath path, DocumentTreeListener<V> listener) {
        this.complete(this.backingMap.addListener(path, listener));
    }

    public void removeListener(DocumentTreeListener<V> listener) {
        this.complete(this.backingMap.removeListener(listener));
    }

    public void addListener(DocumentTreeListener<V> listener) {
        this.complete(this.backingMap.addListener(listener));
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DocumentException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new DocumentException.Timeout(this.name());
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
    }
}

