/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.ImmutableList;
import io.atomix.copycat.Command;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.resources.impl.AtomixWorkQueueCommands;
import org.onosproject.store.primitives.resources.impl.AtomixWorkQueueFactory;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceTypeInfo(id=-154, factory=AtomixWorkQueueFactory.class)
public class AtomixWorkQueue
extends AbstractResource<AtomixWorkQueue>
implements WorkQueue<byte[]> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String TASK_AVAILABLE = "task-available";
    private final ExecutorService executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"AtomixWorkQueue", (String)"%d", (Logger)this.log));
    private final AtomicReference<TaskProcessor> taskProcessor = new AtomicReference();
    private final Timer timer = new Timer("atomix-work-queue-completer");
    private final AtomicBoolean isRegistered = new AtomicBoolean(false);

    protected AtomixWorkQueue(CopycatClient client, Properties options) {
        super(client, options);
    }

    public String name() {
        return null;
    }

    public CompletableFuture<Void> destroy() {
        this.executor.shutdown();
        this.timer.cancel();
        return this.client.submit((Command)new AtomixWorkQueueCommands.Clear());
    }

    public CompletableFuture<AtomixWorkQueue> open() {
        return super.open().thenApply(result -> {
            this.client.onStateChange(state -> {
                if (state == CopycatClient.State.CONNECTED && this.isRegistered.get()) {
                    this.client.submit((Command)new AtomixWorkQueueCommands.Register());
                }
            });
            this.client.onEvent(TASK_AVAILABLE, this::resumeWork);
            return result;
        });
    }

    public CompletableFuture<Void> addMultiple(Collection<byte[]> items) {
        if (items.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.client.submit((Command)new AtomixWorkQueueCommands.Add(items));
    }

    public CompletableFuture<Collection<Task<byte[]>>> take(int maxTasks) {
        if (maxTasks <= 0) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return this.client.submit((Command)new AtomixWorkQueueCommands.Take(maxTasks));
    }

    public CompletableFuture<Void> complete(Collection<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.client.submit((Command)new AtomixWorkQueueCommands.Complete(taskIds));
    }

    public CompletableFuture<Void> registerTaskProcessor(Consumer<byte[]> callback, int parallelism, Executor executor) {
        CompletedTaskAccumulator completedTaskAccumulator = new CompletedTaskAccumulator(this.timer, 50, 50);
        this.taskProcessor.set(new TaskProcessor(callback, parallelism, executor, (Accumulator<String>)completedTaskAccumulator));
        return ((CompletableFuture)this.register().thenCompose(v -> this.take(parallelism))).thenAccept((Consumer)this.taskProcessor.get());
    }

    public CompletableFuture<Void> stopProcessing() {
        return this.unregister();
    }

    public CompletableFuture<WorkQueueStats> stats() {
        return this.client.submit((Command)new AtomixWorkQueueCommands.Stats());
    }

    private void resumeWork() {
        TaskProcessor activeProcessor = this.taskProcessor.get();
        if (activeProcessor == null) {
            return;
        }
        this.take(activeProcessor.headRoom()).whenCompleteAsync((tasks, e) -> activeProcessor.accept((Collection<Task<byte[]>>)tasks), (Executor)this.executor);
    }

    private CompletableFuture<Void> register() {
        return this.client.submit((Command)new AtomixWorkQueueCommands.Register()).thenRun(() -> this.isRegistered.set(true));
    }

    private CompletableFuture<Void> unregister() {
        return this.client.submit((Command)new AtomixWorkQueueCommands.Unregister()).thenRun(() -> this.isRegistered.set(false));
    }

    private class TaskProcessor
    implements Consumer<Collection<Task<byte[]>>> {
        private final AtomicInteger headRoom;
        private final Consumer<byte[]> backingConsumer;
        private final Executor executor;
        private final Accumulator<String> taskCompleter;

        public TaskProcessor(Consumer<byte[]> backingConsumer, int parallelism, Executor executor, Accumulator<String> taskCompleter) {
            this.backingConsumer = backingConsumer;
            this.headRoom = new AtomicInteger(parallelism);
            this.executor = executor;
            this.taskCompleter = taskCompleter;
        }

        public int headRoom() {
            return this.headRoom.get();
        }

        @Override
        public void accept(Collection<Task<byte[]>> tasks) {
            if (tasks == null) {
                return;
            }
            this.headRoom.addAndGet(-1 * tasks.size());
            tasks.forEach(task -> this.executor.execute(() -> {
                try {
                    this.backingConsumer.accept((byte[])task.payload());
                    this.taskCompleter.add((Object)task.taskId());
                }
                catch (Exception e) {
                    AtomixWorkQueue.this.log.debug("Task execution failed", (Throwable)e);
                }
                finally {
                    this.headRoom.incrementAndGet();
                    AtomixWorkQueue.this.resumeWork();
                }
            }));
        }
    }

    private class CompletedTaskAccumulator
    extends AbstractAccumulator<String> {
        CompletedTaskAccumulator(Timer timer, int maxTasksToBatch, int maxBatchMillis) {
            super(timer, maxTasksToBatch, maxBatchMillis, Integer.MAX_VALUE);
        }

        public void processItems(List<String> items) {
            AtomixWorkQueue.this.complete(items);
        }
    }
}

