/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMultimapCommands;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentSetMultimapFactory;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.Versioned;

@ResourceTypeInfo(id=-153, factory=AtomixConsistentSetMultimapFactory.class)
public class AtomixConsistentSetMultimap
extends AbstractResource<AtomixConsistentSetMultimap>
implements AsyncConsistentMultimap<String, byte[]> {
    public AtomixConsistentSetMultimap(CopycatClient client, Properties properties) {
        super(client, properties);
    }

    public CompletableFuture<AtomixConsistentSetMultimap> open() {
        return super.open();
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.Size());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(byte[] value) {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsEntry(String key, byte[] value) {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.ContainsEntry(key, value));
    }

    public CompletableFuture<Boolean> put(String key, byte[] value) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.Put(key, Lists.newArrayList((Object[])new byte[][]{value}), null));
    }

    public CompletableFuture<Boolean> remove(String key, byte[] value) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.MultiRemove(key, Lists.newArrayList((Object[])new byte[][]{value}), null));
    }

    public CompletableFuture<Boolean> removeAll(String key, Collection<? extends byte[]> values) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.MultiRemove(key, values, null));
    }

    public CompletableFuture<Versioned<Collection<? extends byte[]>>> removeAll(String key) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.RemoveAll(key, null));
    }

    public CompletableFuture<Boolean> putAll(String key, Collection<? extends byte[]> values) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.Put(key, values, null));
    }

    public CompletableFuture<Versioned<Collection<? extends byte[]>>> replaceValues(String key, Collection<byte[]> values) {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.Replace(key, values, null));
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit((Command)new AtomixConsistentMultimapCommands.Clear());
    }

    public CompletableFuture<Versioned<Collection<? extends byte[]>>> get(String key) {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.Get(key));
    }

    public CompletableFuture<Set<String>> keySet() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.KeySet());
    }

    public CompletableFuture<Multiset<String>> keys() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.Keys());
    }

    public CompletableFuture<Multiset<byte[]>> values() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.Values());
    }

    public CompletableFuture<Collection<Map.Entry<String, byte[]>>> entries() {
        return this.client.submit((Query)new AtomixConsistentMultimapCommands.Entries());
    }

    public CompletableFuture<Map<String, Collection<byte[]>>> asMap() {
        throw new UnsupportedOperationException("Expensive operation.");
    }

    public String name() {
        return null;
    }

    private void throwIfLocked(MapEntryUpdateResult.Status status) {
        if (status == MapEntryUpdateResult.Status.WRITE_LOCK) {
            throw new ConcurrentModificationException("Cannot update map: Another transaction in progress");
        }
    }
}

