/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.util.CountDownCompleter;
import org.onlab.util.Match;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMapCommands;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.primitives.resources.impl.PrepareResult;
import org.onosproject.store.primitives.resources.impl.RollbackResult;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixConsistentMapState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<Long, Commit<? extends AtomixConsistentMapCommands.Listen>> listeners = new HashMap<Long, Commit<? extends AtomixConsistentMapCommands.Listen>>();
    private final Map<String, MapEntryValue> mapEntries = new HashMap<String, MapEntryValue>();
    private final Set<String> preparedKeys = Sets.newHashSet();
    private final Map<TransactionId, TransactionScope> activeTransactions = Maps.newHashMap();
    private long currentVersion;

    public AtomixConsistentMapState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
    }

    public void install(SnapshotReader reader) {
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixConsistentMapCommands.Listen.class, this::listen);
        executor.register(AtomixConsistentMapCommands.Unlisten.class, this::unlisten);
        executor.register(AtomixConsistentMapCommands.ContainsKey.class, this::containsKey);
        executor.register(AtomixConsistentMapCommands.ContainsValue.class, this::containsValue);
        executor.register(AtomixConsistentMapCommands.EntrySet.class, this::entrySet);
        executor.register(AtomixConsistentMapCommands.Get.class, this::get);
        executor.register(AtomixConsistentMapCommands.GetOrDefault.class, this::getOrDefault);
        executor.register(AtomixConsistentMapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AtomixConsistentMapCommands.KeySet.class, this::keySet);
        executor.register(AtomixConsistentMapCommands.Size.class, this::size);
        executor.register(AtomixConsistentMapCommands.Values.class, this::values);
        executor.register(AtomixConsistentMapCommands.UpdateAndGet.class, this::updateAndGet);
        executor.register(AtomixConsistentMapCommands.Clear.class, this::clear);
        executor.register(AtomixConsistentMapCommands.TransactionBegin.class, this::begin);
        executor.register(AtomixConsistentMapCommands.TransactionPrepare.class, this::prepare);
        executor.register(AtomixConsistentMapCommands.TransactionCommit.class, this::commit);
        executor.register(AtomixConsistentMapCommands.TransactionRollback.class, this::rollback);
        executor.register(AtomixConsistentMapCommands.TransactionPrepareAndCommit.class, this::prepareAndCommit);
    }

    public void delete() {
        this.listeners.values().forEach(Commit::close);
        this.listeners.clear();
        this.mapEntries.values().forEach(MapEntryValue::discard);
        this.mapEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKey(Commit<? extends AtomixConsistentMapCommands.ContainsKey> commit) {
        try {
            MapEntryValue value = this.mapEntries.get(((AtomixConsistentMapCommands.ContainsKey)commit.operation()).key());
            boolean bl = value != null && value.type() != MapEntryValue.Type.TOMBSTONE;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<? extends AtomixConsistentMapCommands.ContainsValue> commit) {
        try {
            Match valueMatch = Match.ifValue((Object)((AtomixConsistentMapCommands.ContainsValue)commit.operation()).value());
            boolean bl = this.mapEntries.values().stream().filter(value -> value.type() != MapEntryValue.Type.TOMBSTONE).anyMatch(value -> valueMatch.matches((Object)value.value()));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Versioned<byte[]> get(Commit<? extends AtomixConsistentMapCommands.Get> commit) {
        try {
            Versioned<byte[]> versioned = this.toVersioned(this.mapEntries.get(((AtomixConsistentMapCommands.Get)commit.operation()).key()));
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versioned<byte[]> getOrDefault(Commit<? extends AtomixConsistentMapCommands.GetOrDefault> commit) {
        try {
            MapEntryValue value = this.mapEntries.get(((AtomixConsistentMapCommands.GetOrDefault)commit.operation()).key());
            if (value == null) {
                Versioned versioned = new Versioned((Object)((AtomixConsistentMapCommands.GetOrDefault)commit.operation()).defaultValue(), 0L);
                return versioned;
            }
            if (value.type() == MapEntryValue.Type.TOMBSTONE) {
                Versioned versioned = new Versioned((Object)((AtomixConsistentMapCommands.GetOrDefault)commit.operation()).defaultValue(), value.version);
                return versioned;
            }
            Versioned versioned = new Versioned((Object)value.value(), value.version);
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    protected int size(Commit<? extends AtomixConsistentMapCommands.Size> commit) {
        try {
            int n = (int)this.mapEntries.values().stream().filter(value -> value.type() != MapEntryValue.Type.TOMBSTONE).count();
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<? extends AtomixConsistentMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.mapEntries.values().stream().noneMatch(value -> value.type() != MapEntryValue.Type.TOMBSTONE);
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> keySet(Commit<? extends AtomixConsistentMapCommands.KeySet> commit) {
        try {
            Set<String> set = this.mapEntries.entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(Map.Entry::getKey).collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected Collection<Versioned<byte[]>> values(Commit<? extends AtomixConsistentMapCommands.Values> commit) {
        try {
            Collection collection = this.mapEntries.entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(entry -> this.toVersioned((MapEntryValue)entry.getValue())).collect(Collectors.toList());
            return collection;
        }
        finally {
            commit.close();
        }
    }

    protected Set<Map.Entry<String, Versioned<byte[]>>> entrySet(Commit<? extends AtomixConsistentMapCommands.EntrySet> commit) {
        try {
            Set<Map.Entry<String, Versioned<byte[]>>> set = this.mapEntries.entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(e -> Maps.immutableEntry(e.getKey(), this.toVersioned((MapEntryValue)e.getValue()))).collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected MapEntryUpdateResult<String, byte[]> updateAndGet(Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit) {
        try {
            MapEvent.Type updateType;
            Versioned newMapValue;
            MapEntryUpdateResult.Status updateStatus = this.validate((AtomixConsistentMapCommands.UpdateAndGet)commit.operation());
            String key = ((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).key();
            MapEntryValue oldCommitValue = this.mapEntries.get(((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).key());
            Versioned<byte[]> oldMapValue = this.toVersioned(oldCommitValue);
            if (updateStatus != MapEntryUpdateResult.Status.OK) {
                commit.close();
                return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldMapValue, oldMapValue);
            }
            byte[] newValue = ((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).value();
            this.currentVersion = commit.index();
            Versioned versioned = newMapValue = newValue == null ? null : new Versioned((Object)newValue, this.currentVersion);
            MapEvent.Type type = newValue == null ? MapEvent.Type.REMOVE : (updateType = oldCommitValue == null ? MapEvent.Type.INSERT : MapEvent.Type.UPDATE);
            if (updateType == MapEvent.Type.REMOVE || updateType == MapEvent.Type.UPDATE) {
                this.mapEntries.remove(key);
                oldCommitValue.discard();
            }
            if (updateType == MapEvent.Type.INSERT || updateType == MapEvent.Type.UPDATE) {
                this.mapEntries.put(key, new NonTransactionalCommit(commit));
            } else if (!this.activeTransactions.isEmpty()) {
                TombstoneCommit tombstone = new TombstoneCommit(commit.index(), new CountDownCompleter(commit, 1L, Commit::close));
                this.mapEntries.put(key, tombstone);
            } else {
                commit.close();
            }
            this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, newMapValue, oldMapValue)}));
            return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldMapValue, newMapValue);
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapEntryUpdateResult.Status clear(Commit<? extends AtomixConsistentMapCommands.Clear> commit) {
        try {
            Iterator<Map.Entry<String, MapEntryValue>> iterator = this.mapEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, MapEntryValue> entry = iterator.next();
                String key = entry.getKey();
                MapEntryValue value = entry.getValue();
                Versioned removedValue = new Versioned((Object)value.value(), value.version());
                this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, null, removedValue)}));
                value.discard();
                iterator.remove();
            }
            MapEntryUpdateResult.Status status = MapEntryUpdateResult.Status.OK;
            return status;
        }
        finally {
            commit.close();
        }
    }

    protected void listen(Commit<? extends AtomixConsistentMapCommands.Listen> commit) {
        Long sessionId = commit.session().id();
        if (this.listeners.putIfAbsent(sessionId, commit) != null) {
            commit.close();
            return;
        }
        commit.session().onStateChange(state -> {
            Commit<? extends AtomixConsistentMapCommands.Listen> listener;
            if ((state == Session.State.CLOSED || state == Session.State.EXPIRED) && (listener = this.listeners.remove(sessionId)) != null) {
                listener.close();
            }
        });
    }

    protected void unlisten(Commit<? extends AtomixConsistentMapCommands.Unlisten> commit) {
        try {
            Commit<? extends AtomixConsistentMapCommands.Listen> listener = this.listeners.remove(commit.session().id());
            if (listener != null) {
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long begin(Commit<? extends AtomixConsistentMapCommands.TransactionBegin> commit) {
        try {
            long version = commit.index();
            this.activeTransactions.put(((AtomixConsistentMapCommands.TransactionBegin)commit.operation()).transactionId(), new TransactionScope(version));
            long l = version;
            return l;
        }
        finally {
            commit.close();
        }
    }

    protected PrepareResult prepareAndCommit(Commit<? extends AtomixConsistentMapCommands.TransactionPrepareAndCommit> commit) {
        TransactionId transactionId = ((AtomixConsistentMapCommands.TransactionPrepareAndCommit)commit.operation()).transactionLog().transactionId();
        PrepareResult prepareResult = this.prepare(commit);
        TransactionScope transactionScope = this.activeTransactions.remove(transactionId);
        if (prepareResult == PrepareResult.OK) {
            this.currentVersion = commit.index();
            transactionScope = transactionScope.prepared(commit);
            this.commit(transactionScope);
        } else if (transactionScope != null) {
            transactionScope.close();
        }
        this.discardTombstones();
        return prepareResult;
    }

    protected PrepareResult prepare(Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> commit) {
        boolean ok = false;
        try {
            PrepareResult prepareResult;
            TransactionLog<MapUpdate<String, byte[]>> transactionLog = ((AtomixConsistentMapCommands.TransactionPrepare)commit.operation()).transactionLog();
            for (MapUpdate record2 : transactionLog.records()) {
                PrepareResult prepareResult2;
                String key = (String)record2.key();
                if (record2.type() == MapUpdate.Type.VERSION_MATCH && key == null) {
                    if (record2.version() <= this.currentVersion) continue;
                    prepareResult2 = PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                    return prepareResult2;
                }
                if (this.preparedKeys.contains(key)) {
                    prepareResult2 = PrepareResult.CONCURRENT_TRANSACTION;
                    return prepareResult2;
                }
                MapEntryValue existingValue = this.mapEntries.get(key);
                if (existingValue == null) {
                    if (record2.version() == transactionLog.version()) continue;
                    PrepareResult prepareResult3 = PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                    return prepareResult3;
                }
                if (existingValue.version() <= record2.version()) continue;
                PrepareResult prepareResult4 = PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                return prepareResult4;
            }
            transactionLog.records().forEach(record -> {
                if (record.type() != MapUpdate.Type.VERSION_MATCH) {
                    this.preparedKeys.add((String)record.key());
                }
            });
            ok = true;
            TransactionScope transactionScope = this.activeTransactions.get(transactionLog.transactionId());
            if (transactionScope == null) {
                this.activeTransactions.put(transactionLog.transactionId(), new TransactionScope(transactionLog.version(), (Commit)commit));
                prepareResult = PrepareResult.PARTIAL_FAILURE;
                return prepareResult;
            }
            this.activeTransactions.put(transactionLog.transactionId(), transactionScope.prepared(commit));
            prepareResult = PrepareResult.OK;
            return prepareResult;
        }
        catch (Exception e) {
            this.log.warn("Failure applying {}", commit, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (!ok) {
                commit.close();
            }
        }
    }

    protected CommitResult commit(Commit<? extends AtomixConsistentMapCommands.TransactionCommit> commit) {
        TransactionId transactionId = ((AtomixConsistentMapCommands.TransactionCommit)commit.operation()).transactionId();
        TransactionScope transactionScope = this.activeTransactions.remove(transactionId);
        if (transactionScope == null) {
            return CommitResult.UNKNOWN_TRANSACTION_ID;
        }
        try {
            this.currentVersion = commit.index();
            CommitResult commitResult = this.commit(transactionScope.committed(commit));
            return commitResult;
        }
        catch (Exception e) {
            this.log.warn("Failure applying {}", commit, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.discardTombstones();
        }
    }

    private CommitResult commit(TransactionScope transactionScope) {
        TransactionLog<MapUpdate<String, byte[]>> transactionLog = transactionScope.transactionLog();
        boolean retainTombstones = !this.activeTransactions.isEmpty();
        long totalReferencesToCommit = transactionLog.records().stream().filter(record -> record.type() != MapUpdate.Type.VERSION_MATCH && record.type() != MapUpdate.Type.LOCK && (record.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH || retainTombstones)).count();
        CountDownCompleter completer = new CountDownCompleter((Object)transactionScope, totalReferencesToCommit, TransactionScope::close);
        ArrayList eventsToPublish = Lists.newArrayList();
        for (MapUpdate record2 : transactionLog.records()) {
            if (record2.type() == MapUpdate.Type.VERSION_MATCH) continue;
            String key = (String)record2.key();
            Preconditions.checkState((boolean)this.preparedKeys.remove(key), (Object)"key is not prepared");
            if (record2.type() == MapUpdate.Type.LOCK) continue;
            MapEntryValue previousValue = this.mapEntries.remove(key);
            MapEntryValue newValue = null;
            if (record2.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
                newValue = new TransactionalCommit(this.currentVersion, (byte[])record2.value(), completer);
            } else if (retainTombstones) {
                newValue = new TombstoneCommit(this.currentVersion, completer);
            }
            eventsToPublish.add(new MapEvent("", (Object)key, this.toVersioned(newValue), this.toVersioned(previousValue)));
            if (newValue != null) {
                this.mapEntries.put(key, newValue);
            }
            if (previousValue == null) continue;
            previousValue.discard();
        }
        this.publish(eventsToPublish);
        return CommitResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RollbackResult rollback(Commit<? extends AtomixConsistentMapCommands.TransactionRollback> commit) {
        TransactionId transactionId = ((AtomixConsistentMapCommands.TransactionRollback)commit.operation()).transactionId();
        TransactionScope transactionScope = this.activeTransactions.remove(transactionId);
        if (transactionScope == null) {
            return RollbackResult.UNKNOWN_TRANSACTION_ID;
        }
        if (!transactionScope.isPrepared()) {
            this.discardTombstones();
            transactionScope.close();
            commit.close();
            return RollbackResult.OK;
        }
        try {
            transactionScope.transactionLog().records().forEach(record -> {
                if (record.type() != MapUpdate.Type.VERSION_MATCH) {
                    this.preparedKeys.remove(record.key());
                }
            });
            RollbackResult rollbackResult = RollbackResult.OK;
            return rollbackResult;
        }
        finally {
            this.discardTombstones();
            transactionScope.close();
            commit.close();
        }
    }

    private void discardTombstones() {
        if (this.activeTransactions.isEmpty()) {
            Iterator<Map.Entry<String, MapEntryValue>> iterator = this.mapEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                MapEntryValue value = iterator.next().getValue();
                if (value.type() != MapEntryValue.Type.TOMBSTONE) continue;
                iterator.remove();
                value.discard();
            }
        } else {
            long lowWaterMark = this.activeTransactions.values().stream().mapToLong(TransactionScope::version).min().getAsLong();
            Iterator<Map.Entry<String, MapEntryValue>> iterator = this.mapEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                MapEntryValue value = iterator.next().getValue();
                if (value.type() != MapEntryValue.Type.TOMBSTONE || value.version >= lowWaterMark) continue;
                iterator.remove();
                value.discard();
            }
        }
    }

    private MapEntryUpdateResult.Status validate(AtomixConsistentMapCommands.UpdateAndGet update) {
        boolean isEmpty;
        MapEntryValue existingValue = this.mapEntries.get(update.key());
        boolean bl = isEmpty = existingValue == null || existingValue.type() == MapEntryValue.Type.TOMBSTONE;
        if (isEmpty && update.value() == null) {
            return MapEntryUpdateResult.Status.NOOP;
        }
        if (this.preparedKeys.contains(update.key())) {
            return MapEntryUpdateResult.Status.WRITE_LOCK;
        }
        byte[] existingRawValue = isEmpty ? null : existingValue.value();
        Long existingVersion = isEmpty ? null : Long.valueOf(existingValue.version());
        return update.valueMatch().matches((Object)existingRawValue) && update.versionMatch().matches((Object)existingVersion) ? MapEntryUpdateResult.Status.OK : MapEntryUpdateResult.Status.PRECONDITION_FAILED;
    }

    private Versioned<byte[]> toVersioned(MapEntryValue value) {
        return value != null && value.type() != MapEntryValue.Type.TOMBSTONE ? new Versioned((Object)value.value(), value.version()) : null;
    }

    private void publish(List<MapEvent<String, byte[]>> events) {
        this.listeners.values().forEach(commit -> commit.session().publish("changeEvents", (Object)events));
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
        this.closeListener(session.id());
    }

    public void expire(ServerSession session) {
        this.closeListener(session.id());
    }

    public void close(ServerSession session) {
        this.closeListener(session.id());
    }

    private void closeListener(Long sessionId) {
        Commit<? extends AtomixConsistentMapCommands.Listen> commit = this.listeners.remove(sessionId);
        if (commit != null) {
            commit.close();
        }
    }

    private static final class TransactionScope {
        private final long version;
        private final Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> prepareCommit;
        private final Commit<? extends AtomixConsistentMapCommands.TransactionCommit> commitCommit;

        private TransactionScope(long version) {
            this(version, (Commit<? extends AtomixConsistentMapCommands.TransactionPrepare>)null, (Commit<? extends AtomixConsistentMapCommands.TransactionCommit>)null);
        }

        private TransactionScope(long version, Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> prepareCommit) {
            this(version, prepareCommit, (Commit<? extends AtomixConsistentMapCommands.TransactionCommit>)null);
        }

        private TransactionScope(long version, Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> prepareCommit, Commit<? extends AtomixConsistentMapCommands.TransactionCommit> commitCommit) {
            this.version = version;
            this.prepareCommit = prepareCommit;
            this.commitCommit = commitCommit;
        }

        long version() {
            return this.version;
        }

        boolean isPrepared() {
            return this.prepareCommit != null;
        }

        TransactionLog<MapUpdate<String, byte[]>> transactionLog() {
            Preconditions.checkState((boolean)this.isPrepared());
            return ((AtomixConsistentMapCommands.TransactionPrepare)this.prepareCommit.operation()).transactionLog();
        }

        TransactionScope prepared(Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> commit) {
            return new TransactionScope(this.version, commit);
        }

        TransactionScope committed(Commit<? extends AtomixConsistentMapCommands.TransactionCommit> commit) {
            Preconditions.checkState((boolean)this.isPrepared());
            return new TransactionScope(this.version, this.prepareCommit, commit);
        }

        void close() {
            if (this.prepareCommit != null) {
                this.prepareCommit.close();
            }
            if (this.commitCommit != null) {
                this.commitCommit.close();
            }
        }
    }

    private static class TombstoneCommit
    extends MapEntryValue {
        private final CountDownCompleter<?> completer;

        public TombstoneCommit(long version, CountDownCompleter<?> completer) {
            super(MapEntryValue.Type.TOMBSTONE, version);
            this.completer = completer;
        }

        @Override
        byte[] value() {
            throw new UnsupportedOperationException();
        }

        @Override
        void discard() {
            this.completer.countDown();
        }
    }

    private static class TransactionalCommit
    extends MapEntryValue {
        private final byte[] value;
        private final CountDownCompleter<?> completer;

        TransactionalCommit(long version, byte[] value, CountDownCompleter<?> completer) {
            super(MapEntryValue.Type.VALUE, version);
            this.value = value;
            this.completer = completer;
        }

        @Override
        byte[] value() {
            return this.value;
        }

        @Override
        void discard() {
            this.completer.countDown();
        }
    }

    private static class NonTransactionalCommit
    extends MapEntryValue {
        private final Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit;

        NonTransactionalCommit(Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit) {
            super(MapEntryValue.Type.VALUE, commit.index());
            this.commit = commit;
        }

        @Override
        byte[] value() {
            return ((AtomixConsistentMapCommands.UpdateAndGet)this.commit.operation()).value();
        }

        @Override
        void discard() {
            this.commit.close();
        }
    }

    private static abstract class MapEntryValue {
        protected final Type type;
        protected final long version;

        MapEntryValue(Type type, long version) {
            this.type = type;
            this.version = version;
        }

        Type type() {
            return this.type;
        }

        long version() {
            return this.version;
        }

        abstract byte[] value();

        abstract void discard();

        static enum Type {
            VALUE,
            TOMBSTONE;

        }
    }
}

