/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.Versioned;

public class UnmodifiableAsyncConsistentMap<K, V>
extends DelegatingAsyncConsistentMap<K, V> {
    private static final String ERROR_MSG = "map updates are not allowed";

    public UnmodifiableAsyncConsistentMap(AsyncConsistentMap<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(""));
    }

    @Override
    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(K key) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return Tools.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }
}

