/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Versioned;

public class TranscodingAsyncConsistentMultimap<K1, V1, K2, V2>
implements AsyncConsistentMultimap<K1, V1> {
    private final AsyncConsistentMultimap<K2, V2> backingMap;
    private final Function<K1, K2> keyEncoder;
    private final Function<K2, K1> keyDecoder;
    private final Function<V2, V1> valueDecoder;
    private final Function<V1, V2> valueEncoder;
    private final Function<? extends Versioned<V2>, ? extends Versioned<V1>> versionedValueTransform;
    private final Function<Versioned<Collection<? extends V2>>, Versioned<Collection<? extends V1>>> versionedValueCollectionDecode;
    private final Function<Collection<? extends V1>, Collection<V2>> valueCollectionEncode;

    public TranscodingAsyncConsistentMultimap(AsyncConsistentMultimap<K2, V2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V2, V1> valueDecoder, Function<V1, V2> valueEncoder) {
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.versionedValueTransform = v -> v == null ? null : v.map(valueDecoder);
        this.versionedValueCollectionDecode = v -> v == null ? null : new Versioned(((Collection)v.value()).stream().map(valueDecoder).collect(Collectors.toSet()), v.version(), v.creationTime());
        this.valueCollectionEncode = v -> v == null ? null : (Collection)v.stream().map(valueEncoder).collect(Collectors.toSet());
    }

    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.backingMap.isEmpty();
    }

    public CompletableFuture<Boolean> containsKey(K1 key) {
        try {
            return this.backingMap.containsKey(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> containsValue(V1 value) {
        try {
            return this.backingMap.containsValue(this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> containsEntry(K1 key, V1 value) {
        try {
            return this.backingMap.containsEntry(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> put(K1 key, V1 value) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> remove(K1 key, V1 value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> removeAll(K1 key, Collection<? extends V1> values) {
        try {
            return this.backingMap.removeAll(this.keyEncoder.apply(key), (Collection)values.stream().map(this.valueEncoder).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<Collection<? extends V1>>> removeAll(K1 key) {
        try {
            return this.backingMap.removeAll(this.keyEncoder.apply(key)).thenApply(this.versionedValueCollectionDecode);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> putAll(K1 key, Collection<? extends V1> values) {
        try {
            return this.backingMap.putAll(this.keyEncoder.apply(key), this.valueCollectionEncode.apply(values));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<Collection<? extends V1>>> replaceValues(K1 key, Collection<V1> values) {
        try {
            return this.backingMap.replaceValues(this.keyEncoder.apply(key), this.valueCollectionEncode.apply(values)).thenApply(this.versionedValueCollectionDecode);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    public CompletableFuture<Versioned<Collection<? extends V1>>> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key)).thenApply(this.versionedValueCollectionDecode);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Set<K1>> keySet() {
        return this.backingMap.keySet().thenApply(s -> s.stream().map(this.keyDecoder).collect(Collectors.toSet()));
    }

    public CompletableFuture<Multiset<K1>> keys() {
        return this.backingMap.keys().thenApply(s -> (Multiset)s.stream().map(this.keyDecoder).collect(new MultisetCollector()));
    }

    public CompletableFuture<Multiset<V1>> values() {
        return this.backingMap.values().thenApply(s -> (Multiset)s.stream().map(this.valueDecoder).collect(new MultisetCollector()));
    }

    public CompletableFuture<Collection<Map.Entry<K1, V1>>> entries() {
        return this.backingMap.entries().thenApply(s -> s.stream().map(e -> Maps.immutableEntry(this.keyDecoder.apply(e.getKey()), this.valueDecoder.apply(e.getValue()))).collect(Collectors.toSet()));
    }

    public CompletableFuture<Map<K1, Collection<V1>>> asMap() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public String name() {
        return this.backingMap.name();
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.backingMap.addStatusChangeListener(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.backingMap.removeStatusChangeListener(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.backingMap.statusChangeListeners();
    }

    private class MultisetCollector<T>
    implements Collector<T, ImmutableMultiset.Builder<T>, Multiset<T>> {
        private MultisetCollector() {
        }

        @Override
        public Supplier<ImmutableMultiset.Builder<T>> supplier() {
            return ImmutableMultiset::builder;
        }

        @Override
        public BiConsumer<ImmutableMultiset.Builder<T>, T> accumulator() {
            return (builder, t) -> builder.add(t);
        }

        @Override
        public BinaryOperator<ImmutableMultiset.Builder<T>> combiner() {
            return (a, b) -> {
                a.addAll((Iterable)b.build());
                return a;
            };
        }

        @Override
        public Function<ImmutableMultiset.Builder<T>, Multiset<T>> finisher() {
            return ImmutableMultiset.Builder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }
}

