/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultTransactionalMapParticipant;
import org.onosproject.store.primitives.impl.DistributedPrimitives;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.primitives.impl.PartitionedTransactionalMap;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.primitives.impl.TransactionalMapParticipant;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionException;

public class TransactionManager {
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final PartitionService partitionService;
    private final List<PartitionId> sortedPartitions;
    private final AsyncConsistentMap<TransactionId, Transaction.State> transactions;
    private final int cacheSize;
    private final Map<PartitionId, Cache<String, AsyncConsistentMap>> partitionCache = Maps.newConcurrentMap();

    public TransactionManager(StorageService storageService, PartitionService partitionService) {
        this(storageService, partitionService, 100);
    }

    public TransactionManager(StorageService storageService, PartitionService partitionService, int cacheSize) {
        this.partitionService = partitionService;
        this.cacheSize = cacheSize;
        this.transactions = ((ConsistentMapBuilder)((ConsistentMapBuilder)storageService.consistentMapBuilder().withName("onos-transactions")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{Transaction.class, Transaction.State.class}))).buildAsyncMap();
        this.sortedPartitions = Lists.newArrayList((Iterable)partitionService.getAllPartitionIds());
        Collections.sort(this.sortedPartitions);
    }

    public Collection<TransactionId> getPendingTransactions() {
        return (Collection)Futures.getUnchecked((Future)this.transactions.keySet());
    }

    <K, V> PartitionedTransactionalMap<K, V> getTransactionalMap(String name, Serializer serializer, TransactionCoordinator transactionCoordinator) {
        HashMap<PartitionId, TransactionalMapParticipant<PartitionId, TransactionalMapParticipant<K, V>>> partitions = new HashMap<PartitionId, TransactionalMapParticipant<PartitionId, TransactionalMapParticipant<K, V>>>();
        for (PartitionId partitionId : this.partitionService.getAllPartitionIds()) {
            partitions.put(partitionId, this.getTransactionalMapPartition(name, partitionId, serializer, transactionCoordinator));
        }
        Hasher<Object> hasher = key -> {
            int hashCode = Hashing.sha256().hashBytes(serializer.encode(key)).asInt();
            return this.sortedPartitions.get(Math.abs(hashCode) % this.sortedPartitions.size());
        };
        return new PartitionedTransactionalMap(partitions, hasher);
    }

    private <K, V> TransactionalMapParticipant<K, V> getTransactionalMapPartition(String mapName, PartitionId partitionId, Serializer serializer, TransactionCoordinator transactionCoordinator) {
        Cache mapCache = this.partitionCache.computeIfAbsent(partitionId, p -> CacheBuilder.newBuilder().maximumSize((long)(this.cacheSize / this.partitionService.getNumberOfPartitions())).build());
        try {
            AsyncConsistentMap baseMap = this.partitionService.getDistributedPrimitiveCreator(partitionId).newAsyncConsistentMap(mapName, serializer);
            AsyncConsistentMap asyncMap = (AsyncConsistentMap)mapCache.get((Object)mapName, () -> DistributedPrimitives.newCachingMap(baseMap));
            Transaction transaction = new Transaction(transactionCoordinator.transactionId, baseMap);
            return new DefaultTransactionalMapParticipant(asyncMap.asConsistentMap(), transaction);
        }
        catch (ExecutionException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    CompletableFuture<Void> updateState(TransactionId transactionId, Transaction.State state) {
        return this.transactions.put((Object)transactionId, (Object)state).thenApply(v -> null);
    }

    CompletableFuture<Void> remove(TransactionId transactionId) {
        return this.transactions.remove((Object)transactionId).thenApply(v -> null);
    }
}

