/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.atomix.copycat.server.cluster.Member;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.service.PartitionInfo;

public class StoragePartitionDetails {
    private final PartitionId partitionId;
    private final Set<Member> activeMembers;
    private final Set<Member> configuredMembers;
    private final Member leader;
    private final long leaderTerm;

    public StoragePartitionDetails(PartitionId partitionId, Collection<Member> activeMembers, Collection<Member> configuredMembers, Member leader, long leaderTerm) {
        this.partitionId = partitionId;
        this.activeMembers = ImmutableSet.copyOf(activeMembers);
        this.configuredMembers = ImmutableSet.copyOf(configuredMembers);
        this.leader = leader;
        this.leaderTerm = leaderTerm;
    }

    public Set<Member> activeMembers() {
        return this.activeMembers;
    }

    public Set<Member> configuredMembers() {
        return this.configuredMembers;
    }

    public Member leader() {
        return this.leader;
    }

    public long leaderTerm() {
        return this.leaderTerm;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("activeMembers", this.activeMembers).add("configuredMembers", this.configuredMembers).add("leader", (Object)this.leader).add("leaderTerm", this.leaderTerm).toString();
    }

    public PartitionInfo toPartitionInfo() {
        Function<Member, String> memberToString = m -> m == null ? "none" : String.format("%s:%d", m.address().host(), m.address().port());
        return new PartitionInfo(this.partitionId.toString(), this.leaderTerm, this.activeMembers.stream().map(memberToString).collect(Collectors.toList()), memberToString.apply(this.leader));
    }
}

