/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Suppliers;
import io.atomix.AtomixClient;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManagerException;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.onlab.util.HexString;
import org.onlab.util.KryoNamespace;
import org.onlab.util.OrderedExecutor;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.impl.DefaultAsyncAtomicValue;
import org.onosproject.store.primitives.impl.DefaultDistributedDocumentTree;
import org.onosproject.store.primitives.impl.DefaultDistributedWorkQueue;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMultimap;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentTreeMap;
import org.onosproject.store.primitives.impl.DistributedPrimitives;
import org.onosproject.store.primitives.impl.ExecutingAsyncAtomicCounter;
import org.onosproject.store.primitives.impl.ExecutingAsyncAtomicCounterMap;
import org.onosproject.store.primitives.impl.ExecutingAsyncAtomicValue;
import org.onosproject.store.primitives.impl.ExecutingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.ExecutingAsyncConsistentMultimap;
import org.onosproject.store.primitives.impl.ExecutingAsyncConsistentTreeMap;
import org.onosproject.store.primitives.impl.ExecutingAsyncDocumentTree;
import org.onosproject.store.primitives.impl.ExecutingAsyncLeaderElector;
import org.onosproject.store.primitives.impl.ExecutingWorkQueue;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.OnosCopycatClient;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.primitives.resources.impl.AtomixAtomicCounterMap;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentSetMultimap;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentTreeMap;
import org.onosproject.store.primitives.resources.impl.AtomixCounter;
import org.onosproject.store.primitives.resources.impl.AtomixDocumentTree;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElector;
import org.onosproject.store.primitives.resources.impl.AtomixWorkQueue;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AsyncAtomicCounterMap;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.PartitionClientInfo;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.WorkQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePartitionClient
implements DistributedPrimitiveCreator,
Managed<StoragePartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StoragePartition partition;
    private final Transport transport;
    private final io.atomix.catalyst.serializer.Serializer serializer;
    private final Executor sharedExecutor;
    private AtomixClient client;
    private ResourceClient resourceClient;
    private static final String ATOMIC_VALUES_CONSISTENT_MAP_NAME = "onos-atomic-values";
    private final com.google.common.base.Supplier<AsyncConsistentMap<String, byte[]>> onosAtomicValuesMap = Suppliers.memoize(() -> this.newAsyncConsistentMap(ATOMIC_VALUES_CONSISTENT_MAP_NAME, Serializer.using((KryoNamespace)KryoNamespaces.BASIC)));
    Function<CopycatClient.State, DistributedPrimitive.Status> mapper = state -> {
        switch (state) {
            case CONNECTED: {
                return DistributedPrimitive.Status.ACTIVE;
            }
            case SUSPENDED: {
                return DistributedPrimitive.Status.SUSPENDED;
            }
            case CLOSED: {
                return DistributedPrimitive.Status.INACTIVE;
            }
        }
        throw new IllegalStateException("Unknown state " + state);
    };

    public StoragePartitionClient(StoragePartition partition, io.atomix.catalyst.serializer.Serializer serializer, Transport transport, Executor sharedExecutor) {
        this.partition = partition;
        this.serializer = serializer;
        this.transport = transport;
        this.sharedExecutor = sharedExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> open() {
        StoragePartitionClient storagePartitionClient = this;
        synchronized (storagePartitionClient) {
            this.resourceClient = this.newResourceClient(this.transport, this.serializer.clone(), StoragePartition.RESOURCE_TYPES);
            this.resourceClient.client().onStateChange(state -> this.log.debug("Partition {} client state changed to {}", (Object)this.partition.getId(), state));
            this.client = new AtomixClient(this.resourceClient);
        }
        return ((CompletableFuture)this.client.connect(this.partition.getMemberAddresses()).whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started client for partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to start client for partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }

    private Executor defaultExecutor(Supplier<Executor> executorSupplier) {
        return executorSupplier != null ? executorSupplier.get() : new OrderedExecutor(this.sharedExecutor);
    }

    public <K, V> AsyncConsistentMap<K, V> newAsyncConsistentMap(final String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixConsistentMap atomixConsistentMap = (AtomixConsistentMap)((Object)this.client.getResource(name, AtomixConsistentMap.class).join());
        Consumer<CopycatClient.State> statusListener = state -> atomixConsistentMap.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        DelegatingAsyncConsistentMap<String, byte[]> rawMap = new DelegatingAsyncConsistentMap<String, byte[]>((AsyncConsistentMap)atomixConsistentMap){

            @Override
            public String name() {
                return name;
            }
        };
        AsyncConsistentMap<Object, Object> transcodedMap = DistributedPrimitives.newTranscodingMap(rawMap, key -> HexString.toHexString((byte[])serializer.encode(key)), string -> serializer.decode(HexString.fromHexString((String)string)), value -> value == null ? null : serializer.encode(value), bytes -> serializer.decode(bytes));
        return new ExecutingAsyncConsistentMap<Object, Object>(transcodedMap, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <V> AsyncConsistentTreeMap<V> newAsyncConsistentTreeMap(final String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixConsistentTreeMap atomixConsistentTreeMap = (AtomixConsistentTreeMap)((Object)this.client.getResource(name, AtomixConsistentTreeMap.class).join());
        Consumer<CopycatClient.State> statusListener = state -> atomixConsistentTreeMap.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        DelegatingAsyncConsistentTreeMap<byte[]> rawMap = new DelegatingAsyncConsistentTreeMap<byte[]>((AsyncConsistentTreeMap)atomixConsistentTreeMap){

            @Override
            public String name() {
                return name;
            }
        };
        AsyncConsistentTreeMap<Object> transcodedMap = DistributedPrimitives.newTranscodingTreeMap(rawMap, value -> value == null ? null : serializer.encode(value), bytes -> serializer.decode(bytes));
        return new ExecutingAsyncConsistentTreeMap<Object>(transcodedMap, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <K, V> AsyncConsistentMultimap<K, V> newAsyncConsistentSetMultimap(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixConsistentSetMultimap atomixConsistentSetMultimap = (AtomixConsistentSetMultimap)((Object)this.client.getResource(name, AtomixConsistentSetMultimap.class).join());
        Consumer<CopycatClient.State> statusListener = state -> atomixConsistentSetMultimap.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        DelegatingAsyncConsistentMultimap<String, byte[]> rawMap = new DelegatingAsyncConsistentMultimap<String, byte[]>((AsyncConsistentMultimap)atomixConsistentSetMultimap){

            @Override
            public String name() {
                return super.name();
            }
        };
        AsyncConsistentMultimap<Object, Object> transcodedMap = DistributedPrimitives.newTranscodingMultimap(rawMap, key -> HexString.toHexString((byte[])serializer.encode(key)), string -> serializer.decode(HexString.fromHexString((String)string)), value -> serializer.encode(value), bytes -> serializer.decode(bytes));
        return new ExecutingAsyncConsistentMultimap<Object, Object>(transcodedMap, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <E> AsyncDistributedSet<E> newAsyncDistributedSet(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        return DistributedPrimitives.newSetFromMap(this.newAsyncConsistentMap(name, serializer, executorSupplier));
    }

    public <K> AsyncAtomicCounterMap<K> newAsyncAtomicCounterMap(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixAtomicCounterMap atomixAtomicCounterMap = (AtomixAtomicCounterMap)((Object)this.client.getResource(name, AtomixAtomicCounterMap.class).join());
        AsyncAtomicCounterMap<Object> transcodedMap = DistributedPrimitives.newTranscodingAtomicCounterMap(atomixAtomicCounterMap, key -> HexString.toHexString((byte[])serializer.encode(key)), string -> serializer.decode(HexString.fromHexString((String)string)));
        return new ExecutingAsyncAtomicCounterMap<Object>(transcodedMap, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public AsyncAtomicCounter newAsyncCounter(String name, Supplier<Executor> executorSupplier) {
        DistributedLong distributedLong = (DistributedLong)this.client.getLong(name).join();
        AtomixCounter asyncCounter = new AtomixCounter(name, distributedLong);
        return new ExecutingAsyncAtomicCounter(asyncCounter, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <V> AsyncAtomicValue<V> newAsyncAtomicValue(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        DefaultAsyncAtomicValue asyncValue = new DefaultAsyncAtomicValue(name, serializer, (AsyncConsistentMap<String, byte[]>)((AsyncConsistentMap)this.onosAtomicValuesMap.get()));
        return new ExecutingAsyncAtomicValue(asyncValue, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <E> WorkQueue<E> newWorkQueue(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixWorkQueue atomixWorkQueue = (AtomixWorkQueue)((Object)this.client.getResource(name, AtomixWorkQueue.class).join());
        DefaultDistributedWorkQueue workQueue = new DefaultDistributedWorkQueue(atomixWorkQueue, serializer);
        return new ExecutingWorkQueue(workQueue, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public <V> AsyncDocumentTree<V> newAsyncDocumentTree(String name, Serializer serializer, Supplier<Executor> executorSupplier) {
        AtomixDocumentTree atomixDocumentTree = (AtomixDocumentTree)((Object)this.client.getResource(name, AtomixDocumentTree.class).join());
        DefaultDistributedDocumentTree asyncDocumentTree = new DefaultDistributedDocumentTree(name, atomixDocumentTree, serializer);
        return new ExecutingAsyncDocumentTree(asyncDocumentTree, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public AsyncLeaderElector newAsyncLeaderElector(String name, Supplier<Executor> executorSupplier) {
        AtomixLeaderElector leaderElector = (AtomixLeaderElector)((Object)((CompletableFuture)this.client.getResource(name, AtomixLeaderElector.class).thenCompose(AtomixLeaderElector::setupCache)).join());
        Consumer<CopycatClient.State> statusListener = state -> leaderElector.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        return new ExecutingAsyncLeaderElector(leaderElector, this.defaultExecutor(executorSupplier), this.sharedExecutor);
    }

    public Set<String> getAsyncConsistentMapNames() {
        return (Set)this.client.keys(AtomixConsistentMap.class).join();
    }

    public Set<String> getAsyncAtomicCounterNames() {
        return (Set)this.client.keys(DistributedLong.class).join();
    }

    public Set<String> getWorkQueueNames() {
        return (Set)this.client.keys(AtomixWorkQueue.class).join();
    }

    @Override
    public boolean isOpen() {
        return this.resourceClient.client().state() != CopycatClient.State.CLOSED;
    }

    public PartitionClientInfo clientInfo() {
        return new PartitionClientInfo(this.partition.getId(), this.partition.getMembers(), this.resourceClient.client().session().id(), this.mapper.apply(this.resourceClient.client().state()));
    }

    private ResourceClient newResourceClient(Transport transport, io.atomix.catalyst.serializer.Serializer serializer, Collection<ResourceType> resourceTypes) {
        ResourceRegistry registry = new ResourceRegistry();
        resourceTypes.forEach(arg_0 -> ((ResourceRegistry)registry).register(arg_0));
        CopycatClient copycatClient = CopycatClient.builder().withServerSelectionStrategy((ServerSelectionStrategy)ServerSelectionStrategies.ANY).withConnectionStrategy((ConnectionStrategy)ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy((RecoveryStrategy)RecoveryStrategies.RECOVER).withTransport(transport).withSerializer(serializer).build();
        copycatClient.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver()});
        for (ResourceType type : registry.types()) {
            try {
                ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(copycatClient.serializer().registry());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResourceManagerException((Throwable)e);
            }
        }
        return new ResourceClient((CopycatClient)new OnosCopycatClient(copycatClient, 5, 100L));
    }
}

