/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Map;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.primitives.impl.TransactionalMapParticipant;
import org.onosproject.store.service.TransactionalMap;

public class PartitionedTransactionalMap<K, V>
implements TransactionalMap<K, V> {
    protected final Map<PartitionId, TransactionalMapParticipant<K, V>> partitions;
    protected final Hasher<K> hasher;

    public PartitionedTransactionalMap(Map<PartitionId, TransactionalMapParticipant<K, V>> partitions, Hasher<K> hasher) {
        this.partitions = partitions;
        this.hasher = hasher;
    }

    Collection<TransactionParticipant> participants() {
        return this.partitions.values();
    }

    private TransactionalMap<K, V> partition(K key) {
        return this.partitions.get(this.hasher.hash(key));
    }

    public V get(K key) {
        return (V)this.partition(key).get(key);
    }

    public boolean containsKey(K key) {
        return this.partition(key).containsKey(key);
    }

    public V put(K key, V value) {
        return (V)this.partition(key).put(key, value);
    }

    public V remove(K key) {
        return (V)this.partition(key).remove(key);
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.partition(key).putIfAbsent(key, value);
    }

    public boolean remove(K key, V value) {
        return this.partition(key).remove(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.partition(key).replace(key, oldValue, newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitions", this.partitions.values()).toString();
    }
}

