/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Throwables;
import io.atomix.catalyst.transport.TransportException;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.error.QueryException;
import io.atomix.copycat.error.UnknownSessionException;
import io.atomix.copycat.session.ClosedSessionException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.DelegatingCopycatClient;
import org.onosproject.store.service.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnosCopycatClient
extends DelegatingCopycatClient {
    private final int maxRetries;
    private final long delayBetweenRetriesMillis;
    private final ScheduledExecutorService executor;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Predicate<Throwable> retryableCheck = e -> e instanceof ConnectException || e instanceof TimeoutException || e instanceof TransportException || e instanceof ClosedChannelException || e instanceof QueryException || e instanceof UnknownSessionException || e instanceof ClosedSessionException || e instanceof StorageException.Unavailable;

    OnosCopycatClient(CopycatClient client, int maxRetries, long delayBetweenRetriesMillis) {
        super(client);
        this.maxRetries = maxRetries;
        this.delayBetweenRetriesMillis = delayBetweenRetriesMillis;
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.maxPriority((ThreadFactory)Tools.groupedThreads((String)"OnosCopycat", (String)"client", (Logger)this.log)));
    }

    @Override
    public CompletableFuture<Void> close() {
        this.executor.shutdown();
        return super.close();
    }

    @Override
    public <T> CompletableFuture<T> submit(Query<T> query) {
        if (this.state() == CopycatClient.State.CLOSED) {
            return Tools.exceptionalFuture((Throwable)new StorageException.Unavailable());
        }
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> this.submit(query, 1, future));
        return future;
    }

    private <T> void submit(Query<T> query, int attemptIndex, CompletableFuture<T> future) {
        this.client.submit(query).whenComplete((r, e) -> {
            if (e != null) {
                if (attemptIndex < this.maxRetries + 1 && this.retryableCheck.test(Throwables.getRootCause((Throwable)e))) {
                    this.log.debug("Retry attempt ({} of {}). Failure due to {}", new Object[]{attemptIndex, this.maxRetries, Throwables.getRootCause((Throwable)e).getClass()});
                    this.executor.schedule(() -> this.submit(query, attemptIndex + 1, future), this.delayBetweenRetriesMillis, TimeUnit.MILLISECONDS);
                } else {
                    future.completeExceptionally((Throwable)e);
                }
            } else {
                future.complete(r);
            }
        });
    }
}

