/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;
import org.onosproject.utils.MeteringAgent;

public class MeteredAsyncConsistentMap<K, V>
extends DelegatingAsyncConsistentMap<K, V> {
    private static final String PRIMITIVE_NAME = "consistentMap";
    private static final String SIZE = "size";
    private static final String IS_EMPTY = "isEmpty";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_VALUE = "containsValue";
    private static final String GET = "get";
    private static final String GET_OR_DEFAULT = "getOrDefault";
    private static final String COMPUTE_IF = "computeIf";
    private static final String PUT = "put";
    private static final String PUT_AND_GET = "putAndGet";
    private static final String PUT_IF_ABSENT = "putIfAbsent";
    private static final String REMOVE = "remove";
    private static final String CLEAR = "clear";
    private static final String KEY_SET = "keySet";
    private static final String VALUES = "values";
    private static final String ENTRY_SET = "entrySet";
    private static final String REPLACE = "replace";
    private static final String COMPUTE_IF_ABSENT = "computeIfAbsent";
    private static final String BEGIN = "begin";
    private static final String PREPARE = "prepare";
    private static final String COMMIT = "commit";
    private static final String ROLLBACK = "rollback";
    private static final String PREPARE_AND_COMMIT = "prepareAndCommit";
    private static final String ADD_LISTENER = "addListener";
    private static final String REMOVE_LISTENER = "removeListener";
    private static final String NOTIFY_LISTENER = "notifyListener";
    private final Map<MapEventListener<K, V>, InternalMeteredMapEventListener> listeners = Maps.newIdentityHashMap();
    private final MeteringAgent monitor;

    public MeteredAsyncConsistentMap(AsyncConsistentMap<K, V> backingMap) {
        super(backingMap);
        this.monitor = new MeteringAgent(PRIMITIVE_NAME, backingMap.name(), true);
    }

    @Override
    public CompletableFuture<Integer> size() {
        MeteringAgent.Context timer = this.monitor.startTimer(SIZE);
        return super.size().whenComplete((r, e) -> timer.stop(e));
    }

    public CompletableFuture<Boolean> isEmpty() {
        MeteringAgent.Context timer = this.monitor.startTimer(IS_EMPTY);
        return super.isEmpty().whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_KEY);
        return super.containsKey(key).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_VALUE);
        return super.containsValue(value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> get(K key) {
        MeteringAgent.Context timer = this.monitor.startTimer(GET);
        return super.get(key).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        MeteringAgent.Context timer = this.monitor.startTimer(GET_OR_DEFAULT);
        return super.getOrDefault(key, defaultValue).whenComplete((r, e) -> timer.stop(e));
    }

    public CompletableFuture<Versioned<V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        MeteringAgent.Context timer = this.monitor.startTimer(COMPUTE_IF_ABSENT);
        return super.computeIfAbsent(key, mappingFunction).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        MeteringAgent.Context timer = this.monitor.startTimer(COMPUTE_IF);
        return super.computeIf(key, condition, remappingFunction).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> put(K key, V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(PUT);
        return super.put(key, value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(PUT_AND_GET);
        return super.putAndGet(key, value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(K key) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return super.remove(key).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Void> clear() {
        MeteringAgent.Context timer = this.monitor.startTimer(CLEAR);
        return super.clear().whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Set<K>> keySet() {
        MeteringAgent.Context timer = this.monitor.startTimer(KEY_SET);
        return super.keySet().whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Collection<Versioned<V>>> values() {
        MeteringAgent.Context timer = this.monitor.startTimer(VALUES);
        return super.values().whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        MeteringAgent.Context timer = this.monitor.startTimer(ENTRY_SET);
        return super.entrySet().whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(PUT_IF_ABSENT);
        return super.putIfAbsent(key, value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return super.remove(key, value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return super.remove(key, version).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        MeteringAgent.Context timer = this.monitor.startTimer(REPLACE);
        return super.replace(key, value).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        MeteringAgent.Context timer = this.monitor.startTimer(REPLACE);
        return super.replace(key, oldValue, newValue).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        MeteringAgent.Context timer = this.monitor.startTimer(REPLACE);
        return super.replace(key, oldVersion, newValue).whenComplete((r, e) -> timer.stop(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD_LISTENER);
        Map<MapEventListener<K, V>, InternalMeteredMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalMeteredMapEventListener meteredListener = this.listeners.computeIfAbsent(listener, k -> new InternalMeteredMapEventListener(listener));
            return super.addListener(meteredListener, executor).whenComplete((r, e) -> timer.stop(e));
        }
    }

    @Override
    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE_LISTENER);
        InternalMeteredMapEventListener meteredListener = this.listeners.remove(listener);
        if (meteredListener != null) {
            return super.removeListener(meteredListener).whenComplete((r, e) -> timer.stop(e));
        }
        timer.stop(null);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Version> begin(TransactionId transactionId) {
        MeteringAgent.Context timer = this.monitor.startTimer(BEGIN);
        return super.begin(transactionId).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, V>> transactionLog) {
        MeteringAgent.Context timer = this.monitor.startTimer(PREPARE);
        return super.prepare(transactionLog).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Void> commit(TransactionId transactionId) {
        MeteringAgent.Context timer = this.monitor.startTimer(COMMIT);
        return super.commit(transactionId).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        MeteringAgent.Context timer = this.monitor.startTimer(ROLLBACK);
        return super.rollback(transactionId).whenComplete((r, e) -> timer.stop(e));
    }

    @Override
    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<K, V>> transactionLog) {
        MeteringAgent.Context timer = this.monitor.startTimer(PREPARE_AND_COMMIT);
        return super.prepareAndCommit(transactionLog).whenComplete((r, e) -> timer.stop(e));
    }

    private class InternalMeteredMapEventListener
    implements MapEventListener<K, V> {
        private final MapEventListener<K, V> listener;

        InternalMeteredMapEventListener(MapEventListener<K, V> listener) {
            this.listener = listener;
        }

        public void event(MapEvent<K, V> event) {
            MeteringAgent.Context timer = MeteredAsyncConsistentMap.this.monitor.startTimer(MeteredAsyncConsistentMap.NOTIFY_LISTENER);
            try {
                this.listener.event(event);
                timer.stop(null);
            }
            catch (Exception e) {
                timer.stop((Throwable)e);
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

