/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;

public class ExecutingWorkQueue<E>
extends ExecutingDistributedPrimitive
implements WorkQueue<E> {
    private final WorkQueue<E> delegateQueue;

    public ExecutingWorkQueue(WorkQueue<E> delegateQueue, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateQueue, orderedExecutor, threadPoolExecutor);
        this.delegateQueue = delegateQueue;
    }

    public CompletableFuture<Void> addMultiple(Collection<E> items) {
        return this.asyncFuture(this.delegateQueue.addMultiple(items));
    }

    public CompletableFuture<Collection<Task<E>>> take(int maxItems) {
        return this.asyncFuture(this.delegateQueue.take(maxItems));
    }

    public CompletableFuture<Void> complete(Collection<String> taskIds) {
        return this.asyncFuture(this.delegateQueue.complete(taskIds));
    }

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> taskProcessor, int parallelism, Executor executor) {
        return this.asyncFuture(this.delegateQueue.registerTaskProcessor(taskProcessor, parallelism, executor));
    }

    public CompletableFuture<Void> stopProcessing() {
        return this.asyncFuture(this.delegateQueue.stopProcessing());
    }

    public CompletableFuture<WorkQueueStats> stats() {
        return this.asyncFuture(this.delegateQueue.stats());
    }
}

