/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentMultimap<K, V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentMultimap<K, V> {
    private final AsyncConsistentMultimap<K, V> delegateMap;

    public ExecutingAsyncConsistentMultimap(AsyncConsistentMultimap<K, V> delegateMap, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateMap, orderedExecutor, threadPoolExecutor);
        this.delegateMap = delegateMap;
    }

    public CompletableFuture<Integer> size() {
        return this.asyncFuture(this.delegateMap.size());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.asyncFuture(this.delegateMap.isEmpty());
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.asyncFuture(this.delegateMap.containsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.asyncFuture(this.delegateMap.containsValue(value));
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.asyncFuture(this.delegateMap.containsEntry(key, value));
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return this.asyncFuture(this.delegateMap.put(key, value));
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.asyncFuture(this.delegateMap.remove(key, value));
    }

    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return this.asyncFuture(this.delegateMap.removeAll(key, values));
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> removeAll(K key) {
        return this.asyncFuture(this.delegateMap.removeAll(key));
    }

    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return this.asyncFuture(this.delegateMap.putAll(key, values));
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> replaceValues(K key, Collection<V> values) {
        return this.asyncFuture(this.delegateMap.replaceValues(key, values));
    }

    public CompletableFuture<Void> clear() {
        return this.asyncFuture(this.delegateMap.clear());
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> get(K key) {
        return this.asyncFuture(this.delegateMap.get(key));
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.asyncFuture(this.delegateMap.keySet());
    }

    public CompletableFuture<Multiset<K>> keys() {
        return this.asyncFuture(this.delegateMap.keys());
    }

    public CompletableFuture<Multiset<V>> values() {
        return this.asyncFuture(this.delegateMap.values());
    }

    public CompletableFuture<Collection<Map.Entry<K, V>>> entries() {
        return this.asyncFuture(this.delegateMap.entries());
    }

    public CompletableFuture<Map<K, Collection<V>>> asMap() {
        return this.asyncFuture(this.delegateMap.asMap());
    }
}

