/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.service.DistributedPrimitive;

public abstract class DelegatingDistributedPrimitive
implements DistributedPrimitive {
    private final DistributedPrimitive primitive;

    public DelegatingDistributedPrimitive(DistributedPrimitive primitive) {
        this.primitive = (DistributedPrimitive)Preconditions.checkNotNull((Object)primitive);
    }

    public String name() {
        return this.primitive.name();
    }

    public DistributedPrimitive.Type primitiveType() {
        return this.primitive.primitiveType();
    }

    public ApplicationId applicationId() {
        return this.primitive.applicationId();
    }

    public CompletableFuture<Void> destroy() {
        return this.primitive.destroy();
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.primitive.addStatusChangeListener(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.primitive.removeStatusChangeListener(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.primitive.statusChangeListeners();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("delegate", (Object)this.primitive).toString();
    }

    public int hashCode() {
        return Objects.hash(this.primitive);
    }

    public boolean equals(Object other) {
        return other instanceof DelegatingDistributedPrimitive && this.primitive.equals(((DelegatingDistributedPrimitive)other).primitive);
    }
}

