/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.utils.MeteringAgent;

public class DefaultAsyncDistributedSet<E>
implements AsyncDistributedSet<E> {
    private static final String CONTAINS = "contains";
    private static final String PRIMITIVE_NAME = "distributedSet";
    private static final String SIZE = "size";
    private static final String IS_EMPTY = "isEmpty";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String CONTAINS_ALL = "containsAll";
    private static final String ADD_ALL = "addAll";
    private static final String RETAIN_ALL = "retainAll";
    private static final String REMOVE_ALL = "removeAll";
    private static final String CLEAR = "clear";
    private static final String GET_AS_IMMUTABLE_SET = "getAsImmutableSet";
    private final String name;
    private final AsyncConsistentMap<E, Boolean> backingMap;
    private final Map<SetEventListener<E>, MapEventListener<E, Boolean>> listenerMapping = Maps.newIdentityHashMap();
    private final MeteringAgent monitor;

    public DefaultAsyncDistributedSet(AsyncConsistentMap<E, Boolean> backingMap, String name, boolean meteringEnabled) {
        this.backingMap = backingMap;
        this.name = name;
        this.monitor = new MeteringAgent(PRIMITIVE_NAME, name, meteringEnabled);
    }

    public String name() {
        return this.name;
    }

    public CompletableFuture<Integer> size() {
        MeteringAgent.Context timer = this.monitor.startTimer(SIZE);
        return this.backingMap.size().whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> isEmpty() {
        MeteringAgent.Context timer = this.monitor.startTimer(IS_EMPTY);
        return this.backingMap.isEmpty().whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> contains(E element) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS);
        return this.backingMap.containsKey(element).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> add(E entry) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD);
        return ((CompletableFuture)this.backingMap.putIfAbsent(entry, (Object)true).thenApply(Objects::isNull)).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> remove(E entry) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return this.backingMap.remove(entry, (Object)true).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_ALL);
        return ((CompletableFuture)Tools.allOf(c.stream().map(this::contains).collect(Collectors.toList())).thenApply(v -> v.stream().reduce(Boolean::logicalAnd).orElse(true))).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD_ALL);
        return ((CompletableFuture)Tools.allOf(c.stream().map(this::add).collect(Collectors.toList())).thenApply(v -> v.stream().reduce(Boolean::logicalOr).orElse(false))).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(RETAIN_ALL);
        return ((CompletableFuture)((CompletableFuture)this.backingMap.keySet().thenApply(set -> Sets.difference((Set)set, (Set)Sets.newHashSet((Iterable)c)))).thenCompose(this::removeAll)).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE_ALL);
        return ((CompletableFuture)Tools.allOf(c.stream().map(this::remove).collect(Collectors.toList())).thenApply(v -> v.stream().reduce(Boolean::logicalOr).orElse(false))).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Void> clear() {
        MeteringAgent.Context timer = this.monitor.startTimer(CLEAR);
        return this.backingMap.clear().whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<? extends Set<E>> getAsImmutableSet() {
        MeteringAgent.Context timer = this.monitor.startTimer(GET_AS_IMMUTABLE_SET);
        return ((CompletableFuture)this.backingMap.keySet().thenApply(s -> ImmutableSet.copyOf((Collection)s))).whenComplete((r, e) -> timer.stop(null));
    }

    public CompletableFuture<Void> addListener(SetEventListener<E> listener) {
        MapEventListener mapEventListener = mapEvent -> {
            if (mapEvent.type() == MapEvent.Type.INSERT) {
                listener.event(new SetEvent(this.name, SetEvent.Type.ADD, mapEvent.key()));
            } else if (mapEvent.type() == MapEvent.Type.REMOVE) {
                listener.event(new SetEvent(this.name, SetEvent.Type.REMOVE, mapEvent.key()));
            }
        };
        if (this.listenerMapping.putIfAbsent(listener, mapEventListener) == null) {
            return this.backingMap.addListener(mapEventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> removeListener(SetEventListener<E> listener) {
        MapEventListener<E, Boolean> mapEventListener = this.listenerMapping.remove(listener);
        if (mapEventListener != null) {
            return this.backingMap.removeListener(mapEventListener);
        }
        return CompletableFuture.completedFuture(null);
    }
}

