/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.Server;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomUtils;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransportConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopycatTransportServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PartitionId partitionId;
    private final String serverSubject;
    private final MessagingService messagingService;
    private final Set<CopycatTransportConnection> connections = Sets.newConcurrentHashSet();

    public CopycatTransportServer(PartitionId partitionId, MessagingService messagingService) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
        this.serverSubject = String.format("onos-copycat-%s", partitionId);
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService, (Object)"messagingService cannot be null");
    }

    public CompletableFuture<Void> listen(Address address, Consumer<Connection> consumer) {
        ThreadContext context = ThreadContext.currentContextOrThrow();
        this.messagingService.registerHandler(this.serverSubject, (sender, payload) -> {
            ByteBuffer requestBuffer = ByteBuffer.wrap(payload);
            if (requestBuffer.get() != 2) {
                ByteBuffer responseBuffer = ByteBuffer.allocate(1);
                responseBuffer.put((byte)2);
                return CompletableFuture.completedFuture(responseBuffer.array());
            }
            long connectionId = RandomUtils.nextLong();
            CopycatTransportConnection connection = new CopycatTransportConnection(connectionId, CopycatTransportConnection.Mode.SERVER, this.partitionId, (Endpoint)sender, this.messagingService, context);
            connection.onClose(this.connections::remove);
            this.connections.add(connection);
            CompletableFuture future = new CompletableFuture();
            context.executor().execute(() -> {
                this.log.debug("Created connection {}-{}", (Object)this.partitionId, (Object)connectionId);
                consumer.accept(connection);
                ByteBuffer responseBuffer = ByteBuffer.allocate(9);
                responseBuffer.put((byte)1);
                responseBuffer.putLong(connectionId);
                future.complete(responseBuffer.array());
            });
            return future;
        });
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.allOf((CompletableFuture[])this.connections.stream().map(Connection::close).toArray(CompletableFuture[]::new));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", (Object)this.partitionId).toString();
    }
}

