/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.TransportException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.MessagingException;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransport;
import org.onosproject.store.primitives.impl.CopycatTransportConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopycatTransportClient
implements Client {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PartitionId partitionId;
    private final String serverSubject;
    private final MessagingService messagingService;
    private final Set<CopycatTransportConnection> connections = Sets.newConcurrentHashSet();

    public CopycatTransportClient(PartitionId partitionId, MessagingService messagingService) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
        this.serverSubject = String.format("onos-copycat-%s", partitionId);
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService, (Object)"messagingService cannot be null");
    }

    public CompletableFuture<Connection> connect(Address address) {
        CompletableFuture<Connection> future = new CompletableFuture<Connection>();
        ThreadContext context = ThreadContext.currentContextOrThrow();
        Endpoint endpoint = CopycatTransport.toEndpoint(address);
        this.log.debug("Connecting to {}", (Object)address);
        ByteBuffer requestBuffer = ByteBuffer.allocate(1);
        requestBuffer.put((byte)2);
        this.messagingService.sendAndReceive(endpoint, this.serverSubject, requestBuffer.array(), context.executor()).whenComplete((payload, error) -> {
            Throwable wrappedError = error;
            if (error != null) {
                Throwable rootCause = Throwables.getRootCause((Throwable)error);
                if (MessagingException.class.isAssignableFrom(rootCause.getClass())) {
                    wrappedError = new TransportException(error);
                }
                this.log.warn("Connection to {} failed! Reason: {}", (Object)address, (Object)wrappedError);
                future.completeExceptionally(wrappedError);
            } else {
                ByteBuffer responseBuffer = ByteBuffer.wrap(payload);
                if (responseBuffer.get() == 1) {
                    long connectionId = responseBuffer.getLong();
                    CopycatTransportConnection connection = new CopycatTransportConnection(connectionId, CopycatTransportConnection.Mode.CLIENT, this.partitionId, endpoint, this.messagingService, context);
                    connection.onClose(this.connections::remove);
                    this.connections.add(connection);
                    future.complete(connection);
                    this.log.debug("Created connection {}-{} to {}", new Object[]{this.partitionId, connectionId, address});
                } else {
                    this.log.warn("Connection to {} failed!");
                    future.completeExceptionally(new ConnectException());
                }
            }
        });
        return future;
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.allOf((CompletableFuture[])this.connections.stream().map(Connection::close).toArray(CompletableFuture[]::new));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", (Object)this.partitionId).toString();
    }
}

