/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAsyncConsistentMap<K, V>
extends DelegatingAsyncConsistentMap<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<K, CompletableFuture<Versioned<V>>> cache;
    private final AsyncConsistentMap<K, V> backingMap;
    private final MapEventListener<K, V> cacheUpdater;
    private final Consumer<DistributedPrimitive.Status> statusListener;

    public CachingAsyncConsistentMap(AsyncConsistentMap<K, V> backingMap) {
        this(backingMap, 10000);
    }

    public CachingAsyncConsistentMap(AsyncConsistentMap<K, V> backingMap, int cacheSize) {
        super(backingMap);
        this.backingMap = backingMap;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(CacheLoader.from(x$0 -> CachingAsyncConsistentMap.super.get(x$0)));
        this.cacheUpdater = event -> {
            Versioned newValue = event.newValue();
            if (newValue == null) {
                this.cache.invalidate(event.key());
            } else {
                this.cache.put(event.key(), CompletableFuture.completedFuture(newValue));
            }
        };
        this.statusListener = status -> {
            this.log.debug("{} status changed to {}", (Object)this.name(), status);
            if (status == DistributedPrimitive.Status.SUSPENDED || status == DistributedPrimitive.Status.INACTIVE) {
                this.cache.invalidateAll();
            }
        };
        super.addListener(this.cacheUpdater);
        super.addStatusChangeListener(this.statusListener);
    }

    @Override
    public CompletableFuture<Void> destroy() {
        super.removeStatusChangeListener(this.statusListener);
        return super.destroy().thenCompose(v -> this.removeListener(this.cacheUpdater));
    }

    @Override
    public CompletableFuture<Versioned<V>> get(K key) {
        return ((CompletableFuture)this.cache.getUnchecked(key)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        return ((CompletableFuture)((CompletableFuture)this.cache.getUnchecked(key)).thenCompose(r -> {
            if (r == null) {
                CompletableFuture versioned = this.backingMap.getOrDefault(key, defaultValue);
                this.cache.put(key, (Object)versioned);
                return versioned;
            }
            return CompletableFuture.completedFuture(r);
        })).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return super.computeIf(key, condition, remappingFunction).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return super.put(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return super.putAndGet(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(K key) {
        return super.remove(key).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return super.clear().whenComplete((r, e) -> this.cache.invalidateAll());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return super.remove(key, value).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        return super.remove(key, version).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return super.replace(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return super.replace(key, oldValue, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return super.replace(key, oldVersion, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }
}

