/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.linkdiscovery.impl;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.LinkDiscovery;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LinkDiscoveryProvider
extends AbstractProvider
implements LinkProvider {
    protected static final String APP_NAME = "org.onosproject.linkdiscovery";
    protected static final String SCHEME_NAME = "linkdiscovery";
    private static final String LINK_PROVIDER_PACKAGE = "org.onosproject.provider.linkdiscovery";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int DEFAULT_POLL_DELAY_SECONDS = 20;
    @Property(name="linkPollDelaySeconds", intValue={20}, label="Initial delay (in seconds) for polling link discovery")
    protected static int linkPollDelaySeconds = 20;
    private static final int DEFAULT_POLL_FREQUENCY_SECONDS = 10;
    @Property(name="linkPollFrequencySeconds", intValue={10}, label="Frequency (in seconds) for polling link discovery")
    protected static int linkPollFrequencySeconds = 10;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    protected ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/netconf-link", (String)"discovery-%d"));
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    protected LinkProviderService providerService;
    private InternalDeviceListener deviceListener = new InternalDeviceListener();
    private ApplicationId appId;
    private ScheduledFuture<?> scheduledTask;

    public LinkDiscoveryProvider() {
        super(new ProviderId(SCHEME_NAME, LINK_PROVIDER_PACKAGE));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.providerService = (LinkProviderService)this.providerRegistry.register((Provider)this);
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        if (context == null) {
            linkPollFrequencySeconds = 10;
            this.log.info("No component configuration");
        } else {
            Dictionary properties = context.getProperties();
            linkPollFrequencySeconds = this.getNewPollFrequency(properties, linkPollFrequencySeconds);
        }
        this.scheduledTask = this.schedulePolling();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.scheduledTask.cancel(true);
        this.executor.shutdown();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        if (context == null) {
            this.log.info("No component configuration");
            return;
        }
        Dictionary properties = context.getProperties();
        int newPollFrequency = this.getNewPollFrequency(properties, linkPollFrequencySeconds);
        int newPollDelay = this.getNewPollDealy(properties, linkPollDelaySeconds);
        if (newPollFrequency != linkPollFrequencySeconds || newPollDelay != linkPollDelaySeconds) {
            linkPollFrequencySeconds = newPollFrequency;
            linkPollDelaySeconds = newPollDelay;
            this.scheduledTask.cancel(true);
            this.scheduledTask = this.schedulePolling();
        }
        this.log.info("Modified");
    }

    private int getNewPollFrequency(Dictionary<?, ?> properties, int pollFrequency) {
        int newPollFrequency;
        try {
            String s = Tools.get(properties, (String)"linkPollFrequencySeconds");
            newPollFrequency = Strings.isNullOrEmpty((String)s) ? pollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPollFrequency = 10;
        }
        return newPollFrequency;
    }

    private int getNewPollDealy(Dictionary<?, ?> properties, int pollDelay) {
        int newPollFrequency;
        try {
            String s = Tools.get(properties, (String)"linkPollDelaySeconds");
            newPollFrequency = Strings.isNullOrEmpty((String)s) ? pollDelay : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPollFrequency = 20;
        }
        return newPollFrequency;
    }

    private ScheduledFuture schedulePolling() {
        return this.executor.scheduleAtFixedRate(this::discoverLinksTasks, linkPollDelaySeconds, linkPollFrequencySeconds, TimeUnit.SECONDS);
    }

    private void discoverLinksTasks() {
        this.deviceService.getAvailableDevices().forEach(device -> {
            if (this.isSupported((Device)device)) {
                this.evaluateLinks(device.id(), ((LinkDiscovery)device.as(LinkDiscovery.class)).getLinks());
            }
        });
    }

    private void evaluateLinks(DeviceId deviceId, Set<LinkDescription> discoveredLinksDesc) {
        if (discoveredLinksDesc == null) {
            return;
        }
        Set<Link> storedLinks = this.linkService.getDeviceEgressLinks(deviceId).stream().filter(link -> {
            String value = link.annotations().value("protocol");
            return value != null && value.equals(SCHEME_NAME.toUpperCase());
        }).collect(Collectors.toSet());
        HashSet storedLinkDescs = new HashSet();
        storedLinks.forEach(link -> storedLinkDescs.add(new DefaultLinkDescription(link.src(), link.dst(), link.type(), link.isExpected(), new SparseAnnotations[]{DefaultAnnotations.builder().putAll(link.annotations()).build()})));
        this.log.debug("Current stored links provider related {}", storedLinks);
        HashSet discoveredLinkDescsAnn = new HashSet();
        discoveredLinksDesc.forEach(linkDesc -> discoveredLinkDescsAnn.add(new DefaultLinkDescription(linkDesc.src(), linkDesc.dst(), linkDesc.type(), false, new SparseAnnotations[]{DefaultAnnotations.builder().putAll((Annotations)linkDesc.annotations()).set("protocol", SCHEME_NAME.toUpperCase()).build()})));
        HashSet linkDescsToBeRemoved = new HashSet(storedLinkDescs);
        linkDescsToBeRemoved.removeAll(discoveredLinkDescsAnn);
        this.log.debug("Links to be removed {}", linkDescsToBeRemoved);
        linkDescsToBeRemoved.forEach(linkDesc -> this.providerService.linkVanished(linkDesc));
        HashSet linksToBeAdded = new HashSet(discoveredLinkDescsAnn);
        linksToBeAdded.removeAll(storedLinkDescs);
        this.log.debug("Links to be added {}", linksToBeAdded);
        linksToBeAdded.forEach(linkDesc -> this.providerService.linkDetected(linkDesc));
    }

    protected boolean isSupported(Device device) {
        boolean supported;
        boolean bl = supported = this.mastershipService.isLocalMaster(device.id()) && device.is(LinkDiscovery.class);
        if (!supported) {
            this.log.debug("Device {} does not support LinkDiscovery", (Object)device);
        }
        return supported;
    }

    protected void bindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.providerRegistry = linkProviderRegistry;
    }

    protected void unbindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.providerRegistry == linkProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.DEVICE_ADDED) {
                LinkDiscoveryProvider.this.executor.execute(() -> ((LinkDiscovery)((Device)event.subject()).as(LinkDiscovery.class)).getLinks().forEach(linkDesc -> LinkDiscoveryProvider.this.providerService.linkDetected((LinkDescription)new DefaultLinkDescription(linkDesc.src(), linkDesc.dst(), linkDesc.type(), false, new SparseAnnotations[]{DefaultAnnotations.builder().putAll((Annotations)linkDesc.annotations()).set("protocol", LinkDiscoveryProvider.SCHEME_NAME.toUpperCase()).build()}))));
            }
        }

        public boolean isRelevant(DeviceEvent event) {
            return LinkDiscoveryProvider.this.isSupported((Device)event.subject());
        }
    }
}

