/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.base.Preconditions;
import org.mapdb.DB;
import org.onosproject.persistence.PersistentSetBuilder;
import org.onosproject.persistence.impl.PersistentSet;
import org.onosproject.store.service.Serializer;

public class DefaultPersistentSetBuilder<E>
implements PersistentSetBuilder<E> {
    private final DB localDB;
    private String name = null;
    private Serializer serializer = null;

    public DefaultPersistentSetBuilder(DB localDB) {
        this.localDB = (DB)Preconditions.checkNotNull((Object)localDB, (Object)"The local database cannot be null.");
    }

    public PersistentSetBuilder<E> withName(String name) {
        this.name = "set:" + (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public PersistentSetBuilder<E> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((this.serializer == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)serializer);
        this.serializer = serializer;
        return this;
    }

    public PersistentSet<E> build() {
        Preconditions.checkNotNull((Object)this.name, (Object)"The name must be assigned.");
        Preconditions.checkNotNull((Object)this.serializer, (Object)"The serializer must be assigned.");
        return new PersistentSet(this.serializer, this.localDB, this.name);
    }
}

