/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Password;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultPassword
extends InnerModelObject
implements Password {
    protected boolean passwordEnabled;
    protected String passwordValue;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean passwordEnabled() {
        return this.passwordEnabled;
    }

    @Override
    public String passwordValue() {
        return this.passwordValue;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void passwordEnabled(boolean passwordEnabled) {
        this.valueLeafFlags.set(Password.LeafIdentifier.PASSWORDENABLED.getLeafIndex());
        this.passwordEnabled = passwordEnabled;
    }

    @Override
    public void passwordValue(String passwordValue) {
        this.valueLeafFlags.set(Password.LeafIdentifier.PASSWORDVALUE.getLeafIndex());
        this.passwordValue = passwordValue;
    }

    public int hashCode() {
        return Objects.hash(this.passwordEnabled, this.passwordValue, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPassword) {
            DefaultPassword other = (DefaultPassword)obj;
            return Objects.equals(this.passwordEnabled, other.passwordEnabled) && Objects.equals(this.passwordValue, other.passwordValue) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("passwordEnabled=" + this.passwordEnabled).add("passwordValue=" + this.passwordValue).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(Password.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

