/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.BgpTimer;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultBgpTimer
extends InnerModelObject
implements BgpTimer {
    protected int keepAlive;
    protected int holdTime;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public int keepAlive() {
        return this.keepAlive;
    }

    @Override
    public int holdTime() {
        return this.holdTime;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void keepAlive(int keepAlive) {
        this.valueLeafFlags.set(BgpTimer.LeafIdentifier.KEEPALIVE.getLeafIndex());
        this.keepAlive = keepAlive;
    }

    @Override
    public void holdTime(int holdTime) {
        this.valueLeafFlags.set(BgpTimer.LeafIdentifier.HOLDTIME.getLeafIndex());
        this.holdTime = holdTime;
    }

    public int hashCode() {
        return Objects.hash(this.keepAlive, this.holdTime, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBgpTimer) {
            DefaultBgpTimer other = (DefaultBgpTimer)obj;
            return Objects.equals(this.keepAlive, other.keepAlive) && Objects.equals(this.holdTime, other.holdTime) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("keepAlive=" + this.keepAlive).add("holdTime=" + this.holdTime).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(BgpTimer.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

